/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.async.task;

import com.qqt.platform.common.multitenant.async.task.AbstractTransactionalAsyncFutureTask;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class DefaultAsyncFutureTask<T>
extends AbstractTransactionalAsyncFutureTask {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncFutureTask.class);
    private final RequestAttributes requestAttributes;
    private final SecurityContext securityContext;

    public DefaultAsyncFutureTask(PlatformTransactionManager transactionManager, String datasourceKey, EntityManager entityManager, RequestAttributes requestAttributes, SecurityContext securityContext) {
        super(transactionManager, datasourceKey, entityManager);
        this.requestAttributes = requestAttributes;
        this.securityContext = securityContext;
    }

    @Override
    public T doRun() throws Throwable {
        try {
            this.preRun();
            T t = this.doExecute();
            return t;
        }
        finally {
            this.postRun();
        }
    }

    protected abstract T doExecute();

    private void preRun() {
        log.info("\u5f02\u6b65\u4efb\u52a1\u524d\u7f6e\u53c2\u6570\u521d\u59cb\u5316...");
        this.checkParam();
        if (Objects.nonNull(this.requestAttributes)) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.requestAttributes);
        }
        if (Objects.nonNull(this.securityContext)) {
            SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        }
    }

    private void postRun() {
        log.info("\u5f02\u6b65\u4efb\u52a1\u540e\u7f6e\u53c2\u6570\u91cd\u7f6e...");
        if (Objects.nonNull(this.requestAttributes)) {
            RequestContextHolder.resetRequestAttributes();
        }
        if (Objects.nonNull(this.securityContext)) {
            SecurityContextHolder.clearContext();
        }
    }

    private void checkParam() {
    }
}

