/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.async.utils;

import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import java.util.Objects;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class AsyncTaskContextUtil {
    public static void preExecute(String datasourceKey, RequestAttributes requestAttributes, SecurityContext securityContext) {
        DynamicDataSourceContextHolder.clearDataSourceKey();
        DynamicDataSourceContextHolder.setDataSourceKey(datasourceKey);
        if (Objects.nonNull(requestAttributes)) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
        }
        if (Objects.nonNull(securityContext)) {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
    }

    public static void postExecute(RequestAttributes requestAttributes, SecurityContext securityContext) {
        if (Objects.nonNull(requestAttributes)) {
            RequestContextHolder.resetRequestAttributes();
        }
        if (Objects.nonNull(securityContext)) {
            SecurityContextHolder.clearContext();
        }
        DynamicDataSourceContextHolder.clearDataSourceKey();
    }
}

