/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.datasource;

import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MultitenantDynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(MultitenantDynamicDataSource.class);
    private final Map<Object, DataSource> tenantDataSources = new HashMap<Object, DataSource>();
    @Nullable
    private DataSource defaultTenantDataSource;
    private Object lock = new Object();

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.tenantDataSources, (String)"Tenant DataSource router not initialized");
        Object lookupKey = this.determineCurrentLookupKey();
        DataSource dataSource = this.tenantDataSources.get(lookupKey);
        if (dataSource == null || lookupKey == null) {
            dataSource = this.defaultTenantDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSourceContextHolder.getDataSourceKey();
    }

    public void setDefaultTenantDataSource(@Nullable DataSource defaultTenantDataSource) {
        this.defaultTenantDataSource = defaultTenantDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTenantDataSources(Map<Object, Object> dataSources) {
        Object object = this.lock;
        synchronized (object) {
            boolean updated = false;
            if (!CollectionUtils.isEmpty(dataSources)) {
                for (Object key : dataSources.keySet()) {
                    if (this.tenantDataSources.containsKey(key)) continue;
                    updated = true;
                    this.tenantDataSources.put(key, this.resolveSpecifiedDataSource(dataSources.get(key)));
                    log.info("incremental add tenant data source: [{}]", key);
                }
            }
            return updated;
        }
    }

    public List<Object> getAllDatasourceNames() {
        return new ArrayList<Object>(this.tenantDataSources.keySet());
    }
}

