/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.endpoint;

import com.qqt.platform.common.multitenant.builder.MultitenantDynamicDataSourceBuilder;
import com.qqt.platform.common.multitenant.datasource.MultitenantDynamicDataSource;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.multitenant.remote.dto.RemoteTenantDataSourceConfig;
import com.qqt.platform.common.multitenant.remote.query.RemoteTenantDataSourceQuerier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnProperty(prefix="multitenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class DatasourceIncrementUpdateComponent {
    private final Logger log = LoggerFactory.getLogger(DatasourceIncrementUpdateComponent.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private RemoteTenantDataSourceQuerier remoteTenantDataSourceQuerier;
    @Autowired
    private MultitenantDynamicDataSourceBuilder multitenantDynamicDataSourceBuilder;
    @Value(value="${spring.application.name}")
    private String appName;

    public boolean incrementUpdate() {
        try {
            boolean incr;
            this.log.info("\u5f00\u59cb\u589e\u91cf\u66f4\u65b0\u6570\u636e\u6e90...");
            List<RemoteTenantDataSourceConfig> remoteTenantDataSourceConfigs = this.remoteTenantDataSourceQuerier.queryRemoteTenantDataSourceConfig(this.appName);
            Map<Object, Object> dataSources = this.multitenantDynamicDataSourceBuilder.getDataSources();
            this.removeDuplicateConfig(dataSources, remoteTenantDataSourceConfigs);
            if (CollectionUtils.isEmpty(remoteTenantDataSourceConfigs)) {
                this.log.info("\u6ca1\u6709\u9700\u8981\u589e\u91cf\u66f4\u65b0\u7684\u6570\u636e\u6e90");
                return false;
            }
            this.multitenantDynamicDataSourceBuilder.buildTenantDataSource(remoteTenantDataSourceConfigs);
            List<String> keywords = dataSources.keySet().stream().map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dataSources) && (incr = ((MultitenantDynamicDataSource)((Object)this.dataSource)).updateTenantDataSources(dataSources))) {
                DynamicDataSourceContextHolder.addDataSourceKeywords(keywords);
            }
            this.log.info("\u7ed3\u675f\u589e\u91cf\u66f4\u65b0\u6570\u636e\u6e90...");
            return true;
        }
        catch (Exception e) {
            this.log.error("\u589e\u52a0\u66f4\u65b0\u6570\u636e\u6e90\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private void removeDuplicateConfig(Map<Object, Object> dataSources, List<RemoteTenantDataSourceConfig> newConfig) {
        if (!CollectionUtils.isEmpty(newConfig)) {
            Iterator<RemoteTenantDataSourceConfig> iterator = newConfig.iterator();
            while (iterator.hasNext()) {
                RemoteTenantDataSourceConfig tenantDataSourceConfig = iterator.next();
                String keyword = this.multitenantDynamicDataSourceBuilder.getTenantDynamicDataSourceAlias(tenantDataSourceConfig.getElsAccount());
                if (!dataSources.containsKey(keyword)) continue;
                iterator.remove();
            }
        }
    }

    public Map<String, Object> metrics() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("appName", this.appName);
        info.put("lookupKeys", DynamicDataSourceContextHolder.getDataSourceKeywords());
        info.put("datasourceNames", ((MultitenantDynamicDataSource)((Object)this.dataSource)).getAllDatasourceNames());
        return info;
    }
}

