/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.redis.template;

import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.multitenant.redis.util.CacheKeyNamespaceUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QQTRedisTemplate {
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${spring.application.name}")
    private String appName;

    public void opsForValueSet(String key, Object value, long timeout, TimeUnit unit, boolean isCommonCache) {
        if (isCommonCache) {
            this.redisTemplate.opsForValue().set((Object)this.rewriteCommonCacheKey(key), value, timeout, unit);
        } else {
            this.opsForValueSet(key, value, timeout, unit);
        }
    }

    public void opsForValueSet(String key, Object value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)this.rewriteCacheKey(key), value, timeout, unit);
    }

    public void opsForValueSet(String key, Object value, Duration timeout) {
        this.redisTemplate.opsForValue().set((Object)this.rewriteCacheKey(key), value, timeout);
    }

    public void opsForValueSet(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)this.rewriteCacheKey(key), value);
    }

    public void opsForValueSet(String key, Object value, boolean isCommonCache) {
        if (isCommonCache) {
            this.redisTemplate.opsForValue().set((Object)this.rewriteCommonCacheKey(key), value);
        } else {
            this.opsForValueSet(key, value);
        }
    }

    public Long opsForValueIncrement(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)this.rewriteCacheKey(key), delta);
    }

    public Boolean opsForValueSetIfAbsent(String key, Object value, long timeout, TimeUnit unit, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.opsForValue().setIfAbsent((Object)this.rewriteCommonCacheKey(key), value, timeout, unit);
        }
        return this.opsForValueSetIfAbsent(key, value, timeout, unit);
    }

    public Boolean opsForValueSetIfAbsent(String key, Object value, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)this.rewriteCacheKey(key), value, timeout, unit);
    }

    public Object opsForValueGet(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.opsForValue().get((Object)this.rewriteCommonCacheKey(key));
        }
        return this.opsForValueGet(key);
    }

    public Object opsForValueGet(String key) {
        return this.redisTemplate.opsForValue().get((Object)this.rewriteCacheKey(key));
    }

    public void opsForHashPutAll(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)this.rewriteCacheKey(key), map);
    }

    public void opsForHashPutAll(String key, Map<String, Object> map, boolean isCommonCache) {
        this.delete(key, isCommonCache);
        if (isCommonCache) {
            this.redisTemplate.opsForHash().putAll((Object)this.rewriteCommonCacheKey(key), map);
        } else {
            this.opsForHashPutAll(key, map);
        }
    }

    public void opsForHashPut(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)this.rewriteCacheKey(key), (Object)hashKey, value);
    }

    public void opsForHashPut(String key, String hashKey, Object value, boolean isCommonCache) {
        if (isCommonCache) {
            this.redisTemplate.opsForHash().put((Object)this.rewriteCommonCacheKey(key), (Object)hashKey, value);
        } else {
            this.opsForHashPut(key, hashKey, value);
        }
    }

    public Map<String, Object> opsForHashEntries(String key) {
        return this.redisTemplate.opsForHash().entries((Object)this.rewriteCacheKey(key));
    }

    public Map<String, Object> opsForHashEntries(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.opsForHash().entries((Object)this.rewriteCommonCacheKey(key));
        }
        return this.opsForHashEntries(key);
    }

    public Object opsForHashGet(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)this.rewriteCacheKey(key), (Object)hashKey);
    }

    public Object opsForHashGet(String key, String hashKey, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.opsForHash().get((Object)this.rewriteCommonCacheKey(key), (Object)hashKey);
        }
        return this.opsForHashGet(key, hashKey);
    }

    public Set<Object> opsForSetMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)this.rewriteCacheKey(key));
    }

    public Long opsForSetAddMember(String key, Object ... values) {
        return this.redisTemplate.opsForSet().add((Object)this.rewriteCacheKey(key), values);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)this.rewriteCacheKey(pattern));
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)this.rewriteCacheKey(key));
    }

    public Boolean hasKey(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.hasKey((Object)this.rewriteCommonCacheKey(key));
        }
        return this.hasKey(key);
    }

    public Boolean delete(String key, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.delete((Object)this.rewriteCommonCacheKey(key));
        }
        return this.delete(key);
    }

    public Boolean delete(String key) {
        return this.redisTemplate.delete((Object)this.rewriteCacheKey(key));
    }

    public Boolean delete(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        List rewriteKeys = keys.stream().map(key -> this.rewriteCacheKey((String)key)).collect(Collectors.toList());
        this.redisTemplate.delete(rewriteKeys);
        return true;
    }

    public Long deleteWithRewriteKeys(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public Boolean deleteSecondLevelCache(String key) {
        return this.redisTemplate.delete((Object)CacheKeyNamespaceUtil.getSecondLevelCacheKey(this.appName, key));
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)this.rewriteCacheKey(key), timeout, unit);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit, boolean isCommonCache) {
        if (isCommonCache) {
            return this.redisTemplate.expire((Object)this.rewriteCommonCacheKey(key), timeout, unit);
        }
        return this.expire(key, timeout, unit);
    }

    private String rewriteCacheKey(String originalKey) {
        String dskey = DynamicDataSourceContextHolder.getDataSourceKey();
        if (PlatformDataSourceKeyword.PLATFORM.getKeyword("").equals(dskey)) {
            return CacheKeyNamespaceUtil.getPlatformCacheKey(this.appName, originalKey);
        }
        String elsAccount = dskey.split("_")[1];
        return CacheKeyNamespaceUtil.getTenantCacheKey(this.appName, elsAccount, originalKey);
    }

    private String rewriteCommonCacheKey(String originalKey) {
        return CacheKeyNamespaceUtil.getCommonSystemCacheKey(originalKey);
    }

    public void opsForListSet(String key, Object value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForList().leftPushAll((Object)key, new Object[]{value});
        this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public List opsForListGet(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }
}

