/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.redis.util;

import com.qqt.platform.common.multitenant.redis.enums.CacheKeySystemEnum;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CacheKeyNamespaceUtil {
    public static final String SPLIT_CHAR = ":";
    public static final String PLATFORM = "platform";
    public static final String TENANT = "tenant";
    private static final String SECOND_LEVEL_CACHE = "slc";
    public static final String PREFIX_MAIN_B2B = "b2b";
    private static final String PREFIX_PLATFORM = "b2b:%s:platform:";
    private static final String PREFIX_TENANT = "b2b:%s:tenant:";
    private static final String PREFIX_SECOND_LEVEL = "b2b:%s:slc:";

    public static String getSecondLevelCacheKey(String system, String key) {
        if (Objects.isNull((Object)CacheKeySystemEnum.getByCode(system))) {
            system = CacheKeySystemEnum.COMMON.getCode();
        }
        String prefix = String.format(PREFIX_SECOND_LEVEL, system);
        CacheKeyNamespaceUtil.checkNullParam(key);
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(key);
        return buffer.toString();
    }

    public static String getCommonSystemCacheKey(String key) {
        String system = CacheKeySystemEnum.COMMON.getCode();
        String prefix = String.format(PREFIX_PLATFORM, system);
        CacheKeyNamespaceUtil.checkNullParam(key);
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(key);
        return buffer.toString();
    }

    public static String getPlatformCacheKey(String system, String key) {
        if (Objects.isNull((Object)CacheKeySystemEnum.getByCode(system))) {
            system = CacheKeySystemEnum.COMMON.getCode();
        }
        String prefix = String.format(PREFIX_PLATFORM, system);
        CacheKeyNamespaceUtil.checkNullParam(key);
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(key);
        return buffer.toString();
    }

    public static String getTenantCacheKey(String system, String elsAccount, String key) {
        if (Objects.isNull((Object)CacheKeySystemEnum.getByCode(system))) {
            system = CacheKeySystemEnum.COMMON.getCode();
        }
        String prefix = String.format(PREFIX_TENANT, system);
        CacheKeyNamespaceUtil.checkNullParam(elsAccount, key);
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append(elsAccount);
        buffer.append(SPLIT_CHAR);
        buffer.append(key);
        return buffer.toString();
    }

    private static void checkNullParam(String ... params) {
        if (params == null || params.length == 0) {
            throw new RuntimeException("cache params is null");
        }
        for (String param : params) {
            if (!StringUtils.isBlank((CharSequence)param)) continue;
            throw new RuntimeException("cache param is null");
        }
    }
}

