/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.redis.util;

import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import org.hibernate.cache.internal.NaturalIdCacheKey;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class MutilTenantCacheKeysFactory
implements CacheKeysFactory {
    private static final String SPLIT_CHAR = "_";
    public static final String SHORT_NAME = "tenant";
    public static CacheKeysFactory INSTANCE = new MutilTenantCacheKeysFactory();

    public Object createCollectionKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.rewriteCacheKey(id);
    }

    public Object createEntityKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.rewriteCacheKey(id);
    }

    public Object createNaturalIdKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return new NaturalIdCacheKey(naturalIdValues, persister.getPropertyTypes(), persister.getNaturalIdentifierProperties(), null, session);
    }

    public Object getEntityId(Object cacheKey) {
        return cacheKey;
    }

    public Object getCollectionId(Object cacheKey) {
        return cacheKey;
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return ((NaturalIdCacheKey)cacheKey).getNaturalIdValues();
    }

    private Object rewriteCacheKey(Object id) {
        String dskey = DynamicDataSourceContextHolder.getDataSourceKey();
        if (PlatformDataSourceKeyword.PLATFORM.getKeyword("").equals(dskey)) {
            return id;
        }
        return dskey + SPLIT_CHAR + id;
    }
}

