/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api.internal.mapping;

import com.qqt.platform.common.mybank.api.MybankApiException;
import com.qqt.platform.common.mybank.api.internal.mapping.Signer;
import com.qqt.platform.common.mybank.api.internal.util.MybankSignature;

public class DefaultSigner
implements Signer {
    private String privateKey;

    public DefaultSigner(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String sign(String xmlContent, String charset, String signType) throws MybankApiException {
        return MybankSignature.sign(xmlContent, this.privateKey, charset, signType, "request");
    }

    @Override
    public String notifyResponseSign(String xmlContent, String charset, String signType) throws MybankApiException {
        return MybankSignature.sign(xmlContent, this.privateKey, charset, signType, "response");
    }

    @Override
    public String webSign(String content, String charset, String signType) throws MybankApiException {
        return MybankSignature.rsa256SignContent(content, this.privateKey, signType, charset);
    }
}

