/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.security;

import com.qqt.platform.common.exception.BusinessException;
import com.qqt.platform.common.multitenant.redis.template.QQTRedisTemplate;
import io.github.jhipster.config.JHipsterProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecurityException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TokenProvider
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(TokenProvider.class);
    private static final String AUTHORITIES_KEY = "auth";
    private static final String ANONYMOUS_USER = "anonymoususer";
    private Key key;
    private long tokenValidityInMilliseconds;
    private long tokenValidityInMillisecondsForRememberMe;
    private final JHipsterProperties jHipsterProperties;
    @Value(value="${sso.enable:false}")
    private boolean ssoEnable;
    @Autowired
    private QQTRedisTemplate qqtRedisTemplate;
    @Value(value="${ignoreAccount:admin,anonymoususer}")
    private String ignoreAccount;

    public TokenProvider(JHipsterProperties jHipsterProperties) {
        this.jHipsterProperties = jHipsterProperties;
    }

    public void afterPropertiesSet() throws Exception {
        byte[] keyBytes;
        String secret = this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getSecret();
        if (!StringUtils.isEmpty((Object)secret)) {
            this.log.warn("Warning: the JWT key used is not Base64-encoded. We recommend using the `jhipster.security.authentication.jwt.base64-secret` key for optimum security.");
            keyBytes = secret.getBytes(StandardCharsets.UTF_8);
        } else {
            this.log.debug("Using a Base64-encoded JWT secret key");
            keyBytes = (byte[])Decoders.BASE64.decode((Object)this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getBase64Secret());
        }
        this.key = Keys.hmacShaKeyFor((byte[])keyBytes);
        this.tokenValidityInMilliseconds = 1000L * this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSeconds();
        this.tokenValidityInMillisecondsForRememberMe = 1000L * this.jHipsterProperties.getSecurity().getAuthentication().getJwt().getTokenValidityInSecondsForRememberMe();
    }

    public String createToken(Authentication authentication, boolean rememberMe, Map<String, Object> sessionDataMap) {
        String token;
        JwtBuilder jwtBuilder = Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)"QQT").claim("userId", sessionDataMap.get("userId")).claim("proxyUserId", sessionDataMap.get("proxyUserId")).claim("channel", sessionDataMap.get("channel")).claim("siteCode", sessionDataMap.get("siteCode")).claim("languageCode", sessionDataMap.get("languageCode")).claim("currencyCode", sessionDataMap.get("currencyCode")).claim("expireTime", sessionDataMap.get("expireTime"));
        List<String> ignoreList = Arrays.asList(this.ignoreAccount.split(","));
        this.log.debug("\u662f\u5426\u4e0d\u8d70\u5355\u4eba\u767b\u5f55\uff1a{}\uff0cssoEnable:{},\u662f\u5426\u653e\u884c:{}", new Object[]{!this.ssoEnable || ignoreList.contains(authentication.getName()), this.ssoEnable, ignoreList.contains(authentication.getName())});
        if (!this.ssoEnable || ignoreList.contains(authentication.getName())) {
            token = jwtBuilder.signWith(this.key, SignatureAlgorithm.HS512).compact();
        } else {
            Date validity = this.getValidity(rememberMe);
            token = jwtBuilder.claim("validity", (Object)validity).signWith(this.key, SignatureAlgorithm.HS512).compact();
        }
        if (authentication.getName().equals(ANONYMOUS_USER)) {
            rememberMe = true;
        }
        try {
            this.saveToken(token, rememberMe, authentication.getName());
        }
        catch (Throwable e) {
            this.log.error("saveToken error:{}", e);
        }
        return token;
    }

    private Date getValidity(boolean rememberMe) {
        long now = new Date().getTime();
        Date validity = rememberMe ? new Date(now + this.tokenValidityInMillisecondsForRememberMe) : new Date(now + this.tokenValidityInMilliseconds);
        return validity;
    }

    private void saveToken(String token, boolean rememberMe, String login) {
        Date validity;
        long expiredTime;
        long now = new Date().getTime();
        if (rememberMe) {
            expiredTime = this.tokenValidityInMillisecondsForRememberMe;
            validity = new Date(now + this.tokenValidityInMillisecondsForRememberMe);
        } else {
            expiredTime = this.tokenValidityInMilliseconds;
            validity = new Date(now + this.tokenValidityInMilliseconds);
        }
        String tokenKey = this.getKeyFromToken(token);
        this.log.debug("saveToken ==> tokenKey:{},expiredTime:{},expiredSeconds:{}", new Object[]{tokenKey, validity, expiredTime});
        this.qqtRedisTemplate.opsForHashPut(tokenKey, "token", token, true);
        this.qqtRedisTemplate.opsForHashPut(tokenKey, "expiredTime", validity, true);
        this.qqtRedisTemplate.opsForHashPut(tokenKey, "expiredSeconds", expiredTime, true);
        if (!login.equals(ANONYMOUS_USER)) {
            this.qqtRedisTemplate.expire(tokenKey, expiredTime, TimeUnit.MILLISECONDS, true);
        }
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(token).getBody();
        Object object = claims.get((Object)AUTHORITIES_KEY);
        if (Objects.isNull(object) || StringUtils.isEmpty((Object)object.toString())) {
            throw new BusinessException("403", "\u6ca1\u6709\u6743\u9650");
        }
        Collection authorities = Arrays.stream(object.toString().split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        User principal = new User(claims.getSubject(), "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.key).parseClaimsJws(authToken);
            return true;
        }
        catch (MalformedJwtException | SecurityException e) {
            this.log.info("Invalid JWT signature.");
            this.log.trace("Invalid JWT signature trace: {}", e);
        }
        catch (ExpiredJwtException e) {
            this.log.info("Expired JWT token.");
            this.log.trace("Expired JWT token trace: {}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            this.log.info("Unsupported JWT token.");
            this.log.trace("Unsupported JWT token trace: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.log.info("JWT token compact of handler are invalid.");
            this.log.trace("JWT token compact of handler are invalid trace: {}", (Throwable)e);
        }
        return false;
    }

    public String getKeyFromToken(String token) {
        if (StringUtils.isEmpty((Object)token)) {
            throw new BusinessException("403", "token\u4e3a\u7a7a");
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(token).getBody();
        StringBuilder sb = new StringBuilder("JWT_TOKEN:");
        if (claims.containsKey((Object)"userId")) {
            sb.append(claims.get((Object)"userId"));
        }
        if (claims.containsKey((Object)"siteCode")) {
            sb.append("_").append(claims.get((Object)"siteCode").hashCode());
        }
        if (claims.containsKey((Object)"channel")) {
            sb.append("_").append(claims.get((Object)"channel").hashCode());
        }
        if (claims.containsKey((Object)"proxyUserId")) {
            sb.append("_").append(claims.get((Object)"proxyUserId"));
        }
        return sb.toString();
    }

    public String createToken(String login, String authorities, boolean rememberMe, Map<String, Object> sessionDataMap) {
        String token;
        JwtBuilder jwtBuilder = Jwts.builder().setSubject(login).claim(AUTHORITIES_KEY, (Object)authorities).claim("userId", sessionDataMap.get("userId")).claim("channel", sessionDataMap.get("channel")).claim("siteCode", sessionDataMap.get("siteCode")).claim("languageCode", sessionDataMap.get("languageCode")).claim("currencyCode", sessionDataMap.get("currencyCode"));
        List<String> ignoreList = Arrays.asList(this.ignoreAccount.split(","));
        this.log.debug("\u662f\u5426\u4e0d\u8d70\u5355\u4eba\u767b\u5f55\uff1a{}\uff0cssoEnable:{},\u662f\u5426\u653e\u884c:{}", new Object[]{!this.ssoEnable || ignoreList.contains(login), this.ssoEnable, ignoreList.contains(login)});
        if (!this.ssoEnable || ignoreList.contains(login)) {
            token = jwtBuilder.signWith(this.key, SignatureAlgorithm.HS512).compact();
        } else {
            Date validity = this.getValidity(rememberMe);
            token = jwtBuilder.claim("validity", (Object)validity).signWith(this.key, SignatureAlgorithm.HS512).compact();
        }
        try {
            this.saveToken(token, rememberMe, login);
        }
        catch (Throwable e) {
            this.log.error("saveToken error:{}", e);
        }
        return token;
    }

    public String getSiteCodeFromToken(String token) {
        if (StringUtils.isEmpty((Object)token)) {
            throw new BusinessException("403", "token\u4e3a\u7a7a");
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(token).getBody();
        String siteCode = (String)claims.get((Object)"siteCode");
        return siteCode;
    }

    public Object getUserIdFromToken(String token) {
        if (StringUtils.isEmpty((Object)token)) {
            throw new BusinessException("403", "token\u4e3a\u7a7a");
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(token).getBody();
        return claims.get((Object)"userId");
    }
}

