/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service.impl;

import com.qqt.platform.common.service.I18NMsgService;
import com.qqt.platform.common.service.LocaleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class I18NMsgServiceImpl
implements I18NMsgService {
    private static final Logger LOG = LoggerFactory.getLogger(I18NMsgServiceImpl.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LocaleService localeService;

    @Override
    public String getMsg(String code) {
        return this.getMsg(code, null);
    }

    @Override
    public String getMsg(String code, Object[] params) {
        try {
            return this.messageSource.getMessage(code, params, this.localeService.getLocale());
        }
        catch (Exception e) {
            LOG.error("getMsg error,code:" + code, (Throwable)e);
            return code;
        }
    }
}

