/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;

public class DateUtil {
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_FORMAT_DATE = "yyMMdd";
    public static final String ORTHER_PATTERN_DATETIME = "yyyyMMddHHmmss";
    public static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");

    public static Date now() {
        return new Date();
    }

    public static Date plus(Date date, TemporalAmount amount) {
        Instant instant = date.toInstant();
        return Date.from(instant.plus(amount));
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        if (temporal instanceof Instant) {
            temporal = ((Instant)temporal).atZone(ZoneId.systemDefault());
        }
        return DateTimeFormatter.ofPattern(pattern).format(temporal);
    }

    public static <T> T parse(String dateStr, String pattern, TemporalQuery<T> query) {
        return DateTimeFormatter.ofPattern(pattern).parse((CharSequence)dateStr, query);
    }

    public static Instant toInstant(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(DateUtil.toInstant(dateTime));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Duration between(Temporal startInclusive, Temporal endExclusive) {
        return Duration.between(startInclusive, endExclusive);
    }

    public static Period between(LocalDate startDate, LocalDate endDate) {
        return Period.between(startDate, endDate);
    }

    public static Duration between(Date startDate, Date endDate) {
        return Duration.between(startDate.toInstant(), endDate.toInstant());
    }

    public static String genSystemSequenceNumberForPinganTxnTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(ORTHER_PATTERN_DATETIME);
        String format = sdf.format(new Date());
        return format + "000";
    }

    public static String genSystemSequenceNumberForPinganCnsmrSeqNo(String uid) {
        String first = uid;
        String second = LocalDateTime.now().format(DATE_FORMATTER);
        String third = String.format("%010d", DateUtil.genAnyDigitRandom(10));
        return String.format("%s%s%s", first, second, third);
    }

    public static long genAnyDigitRandom(int n) {
        long max = (long)Math.pow(10.0, n);
        return ThreadLocalRandom.current().nextLong(1L, max);
    }
}

