/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.utils.LocalRedissonRegionFactory;
import java.util.Map;
import org.hibernate.cache.spi.support.AbstractReadWriteAccess;
import org.redisson.api.RMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityCacheUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityCacheUtils.class);

    public Map getFromCache(Class clazz, Long id) {
        return this.getFromCache(clazz.getName(), id);
    }

    public Map getFromCache(String className, Long id) {
        try {
            Object obj;
            RMapCache rMapCache = LocalRedissonRegionFactory.getMapCache(className);
            if (rMapCache != null && (obj = rMapCache.get(this.rewriteCacheKey(id))) != null) {
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    map.put("id", id);
                    return map;
                }
                if (obj instanceof AbstractReadWriteAccess.Item) {
                    AbstractReadWriteAccess.Item item = (AbstractReadWriteAccess.Item)obj;
                    Map map = (Map)item.getValue();
                    map.put("id", id);
                    return map;
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("get from cache error,className:" + className + ",id:" + id, (Throwable)e);
            return null;
        }
    }

    private Object rewriteCacheKey(Object id) {
        String dataSourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
        if (PlatformDataSourceKeyword.PLATFORM.getValue().equals(dataSourceKey)) {
            return id;
        }
        return dataSourceKey + "_" + id;
    }
}

