/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.SpringUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    public static void initMDC(boolean hasJwt) {
        try {
            if (hasJwt) {
                SessionService sessionService = SpringUtils.getBean(SessionService.class);
                String siteElsAccount = sessionService.getSiteElsAccount();
                String elsAccount = sessionService.getElsAccount();
                String userAccount = sessionService.getCurrentUserCode();
                MDC.put((String)"siteElsAccount", (String)siteElsAccount);
                MDC.put((String)"elsAccount", (String)elsAccount);
                MDC.put((String)"userAccount", (String)userAccount);
            } else {
                ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                HttpServletRequest request = requestAttributes.getRequest();
                String elsAccount = request.getHeader("Tenant-Els-Account");
                if (StringUtils.isNotBlank((CharSequence)elsAccount)) {
                    MDC.put((String)"siteElsAccount", (String)elsAccount);
                }
            }
        }
        catch (Exception e) {
            log.error("initMDC error", (Throwable)e);
        }
    }
}

