/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.alibaba.fastjson.JSON;
import com.qqt.platform.common.utils.ClassUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Predicate;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

public class WebUtil
extends WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    public static final String USER_AGENT_HEADER = "user-agent";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String[] IP_HEADER_NAMES = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final Predicate<String> IP_PREDICATE = ip -> StringUtils.isEmpty((Object)ip) || "unknown".equalsIgnoreCase((String)ip);

    public static boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtil.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    @Nullable
    public static String getCookieVal(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        Assert.notNull((Object)request, (String)"request from RequestContextHolder is null");
        return WebUtil.getCookieVal(request, name);
    }

    @Nullable
    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = WebUtil.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        WebUtil.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static void renderJson(HttpServletResponse response, Object result) {
        WebUtil.renderJson(response, result, "application/json;charset=UTF-8");
    }

    public static void renderJson(HttpServletResponse response, Object result, String contentType) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try (PrintWriter out = response.getWriter();){
            out.append(JSON.toJSONString((Object)result));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getIP() {
        return WebUtil.getIP(WebUtil.getRequest());
    }

    @Nullable
    public static String getIP(@Nullable HttpServletRequest request) {
        String ipHeader;
        if (request == null) {
            return "";
        }
        String ip = null;
        String[] stringArray = IP_HEADER_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && IP_PREDICATE.test(ip = request.getHeader(ipHeader = stringArray[i])); ++i) {
        }
        if (IP_PREDICATE.test(ip)) {
            ip = request.getRemoteAddr();
        }
        if (!StringUtils.isEmpty(ip) && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static String getHeader(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        return Objects.requireNonNull(request).getHeader(name);
    }

    public static Enumeration<String> getHeaders(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        return Objects.requireNonNull(request).getHeaders(name);
    }

    public static Enumeration<String> getHeaderNames() {
        HttpServletRequest request = WebUtil.getRequest();
        return Objects.requireNonNull(request).getHeaderNames();
    }

    public static String getParameter(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        return Objects.requireNonNull(request).getParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequestBody(ServletInputStream servletInputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)servletInputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (servletInputStream != null) {
                try {
                    servletInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static String getRequestContent(HttpServletRequest request) {
        try {
            String body;
            String queryString = request.getQueryString();
            if (!StringUtils.isEmpty((Object)queryString)) {
                return new String(queryString.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8).replaceAll("&amp;", "&").replaceAll("%22", "\"");
            }
            String charEncoding = request.getCharacterEncoding();
            if (charEncoding == null) {
                charEncoding = "UTF-8";
            }
            if (StringUtils.isEmpty((Object)(body = WebUtil.getRequestBody(request.getInputStream())))) {
                return "";
            }
            byte[] buffer = WebUtil.getRequestBody(request.getInputStream()).getBytes();
            String str = new String(buffer, charEncoding).trim();
            if (StringUtils.isEmpty((Object)str)) {
                StringBuilder sb = new StringBuilder();
                Enumeration parameterNames = request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String key = (String)parameterNames.nextElement();
                    String value = request.getParameter(key);
                    WebUtil.appendBuilder(sb, key, "=", value, "&");
                }
                str = WebUtil.removeSuffix(sb.toString(), "&");
            }
            return str.replaceAll("&amp;", "&");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (StringUtils.isEmpty((Object)str) || StringUtils.isEmpty((Object)suffix)) {
            return "";
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return WebUtil.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String subPre(CharSequence string, int toIndex) {
        return WebUtil.sub(string, 0, toIndex);
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtils.isEmpty((Object)str)) {
            return "";
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return "";
        }
        return str.toString().substring(fromIndex, toIndex);
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        for (CharSequence str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static String getHostByHttpRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String host = request.getHeader("x-forwarded-host");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)host)) {
            host = request.getHeader("Host");
        }
        return host;
    }
}

