/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.web;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.config.AbstractCriteria;
import com.qqt.platform.common.utils.PackageScanner;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/filter"})
public class FilterController {
    public static final Logger logger = LoggerFactory.getLogger(FilterController.class);

    @GetMapping(value={"/{criteriaName}"})
    public JSONObject getFilters(@PathVariable(value="criteriaName") String criteriaName) {
        Optional<String> optional = PackageScanner.findClass(criteriaName, "com.qqt");
        if (optional.isPresent()) {
            String name = optional.get();
            logger.debug("name=>{}", (Object)name);
            Object object = null;
            try {
                object = Class.forName(name).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            if (object instanceof AbstractCriteria) {
                JSONObject jsonObject = ((AbstractCriteria)object).getFilters();
                logger.debug("filters=>{}", (Object)jsonObject.toString());
                return jsonObject;
            }
        }
        return null;
    }
}

