/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.mp.common.criteria;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.base.CaseFormat;
import com.qqt.platform.common.exception.BusinessException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public interface CrudRepository<T>
extends BaseMapper<T> {
    default public T save(T entity) {
        if (Objects.nonNull(entity)) {
            this.insertOrUpdate(entity);
        }
        return entity;
    }

    default public List<T> saveAll(Iterable<T> entities) {
        if (entities != null && entities.iterator() != null && entities.iterator().hasNext()) {
            Iterator<T> iterator = entities.iterator();
            ArrayList<T> list = new ArrayList<T>();
            while (iterator.hasNext()) {
                T next = iterator.next();
                this.insertOrUpdate(next);
                list.add(next);
            }
            return list;
        }
        return Collections.emptyList();
    }

    default public T saveAndFlush(T entity) {
        return this.save(entity);
    }

    public T queryById(Serializable var1);

    default public T getOne(Serializable id) {
        return this.queryById(id);
    }

    default public Optional<T> findById(Serializable id) {
        return Optional.ofNullable(this.queryById(id));
    }

    default public List<T> findAll() {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(1L, 1000L);
        IPage selectPage = this.selectPage((IPage)page, (Wrapper)new LambdaQueryWrapper());
        if (selectPage == null) {
            return Collections.emptyList();
        }
        return selectPage.getRecords();
    }

    default public com.baomidou.mybatisplus.extension.plugins.pagination.Page<T> fillSortPage(Pageable pageable) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)(pageable.getPageNumber() + 1), (long)pageable.getPageSize());
        Sort sort = pageable.getSort();
        if (sort != null) {
            ArrayList orders = new ArrayList();
            pageable.getSort().get().forEach(order -> {
                String column = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, order.getProperty());
                if (order.getDirection().equals((Object)Sort.Direction.ASC)) {
                    orders.add(OrderItem.asc((String)column));
                } else if (order.getDirection().equals((Object)Sort.Direction.DESC)) {
                    orders.add(OrderItem.desc((String)column));
                }
            });
            page.addOrder(orders);
        }
        return page;
    }

    default public Page<T> findAll(Pageable pageable) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<T> page = this.fillSortPage(pageable);
        IPage selectPage = this.selectPage((IPage)page, (Wrapper)new LambdaQueryWrapper());
        return Objects.isNull(selectPage) ? null : new PageImpl(selectPage.getRecords(), pageable, selectPage.getTotal());
    }

    default public Page<T> findByCondition(Pageable pageable, T t) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<T> page = this.fillSortPage(pageable);
        IPage<T> selectPage = this.queryByCondition((IPage<T>)page, t);
        return Objects.isNull(selectPage) ? null : new PageImpl(selectPage.getRecords(), pageable, selectPage.getTotal());
    }

    public IPage<T> queryByCondition(IPage<T> var1, @Param(value="entity") T var2);

    public List<T> queryByIds(@Param(value="ids") Collection<? extends Serializable> var1);

    default public List<T> findAllById(Collection<? extends Serializable> ids) {
        return this.queryByIds(ids);
    }

    default public void delete(T entity) {
        try {
            if (!Objects.isNull(entity)) {
                Object obj;
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor("id", entity.getClass());
                Method method = propertyDescriptor == null ? null : propertyDescriptor.getReadMethod();
                Object object = obj = method == null ? null : method.invoke(entity, new Object[0]);
                if (obj != null) {
                    this.deleteById((Serializable)obj);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("delete.error", e.getMessage());
        }
    }

    default public void deleteAll(Iterable<T> entities) {
        if (entities != null && entities.iterator().hasNext()) {
            for (T next : entities) {
                this.delete(next);
            }
        }
    }

    default public T insertOrUpdate(T entity) {
        int count = !StringUtils.checkValNull((Object)this.pkVal(entity)) && !Objects.isNull(this.selectById(this.pkVal(entity))) ? this.updateById(entity) : this.insert(entity);
        return entity;
    }

    default public Serializable pkVal(T entity) {
        return (Serializable)ReflectionKit.getFieldValue(entity, (String)TableInfoHelper.getTableInfo(entity.getClass()).getKeyProperty());
    }

    public Long count(T var1);

    public Integer insertBatch(@Param(value="entities") Collection<T> var1);

    public List<T> queryAllByLimit(@Param(value="entity") T var1, @Param(value="pageable") Pageable var2);
}

