/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.mp.common.facade.mapper;

import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.utils.AdminEntityCacheUtils;
import com.qqt.platform.mp.common.domain.AbstractAuditingEntity;
import com.qqt.platform.mp.common.domain.AbstractCompanyEntity;
import com.qqt.platform.mp.common.domain.AbstractMpAuditingEntity;
import com.qqt.platform.mp.common.domain.AbstractMpCompanyEntity;
import com.qqt.platform.mp.common.domain.IAuditingEntity;
import com.qqt.platform.mp.common.dto.IAuditingDTO;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AuditingDTOMapper<DTO extends IAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditingEntity(DTO auditingDTO, @MappingTarget Entity auditingEntity) {
        if (auditingEntity instanceof AbstractAuditingEntity) {
            ((AbstractAuditingEntity)auditingEntity).setMultipleFields(auditingDTO.getMultipleFields());
        } else if (auditingEntity instanceof AbstractMpAuditingEntity) {
            ((AbstractMpAuditingEntity)auditingEntity).setMultipleFields(auditingDTO.getMultipleFields());
        } else if (auditingEntity instanceof AbstractCompanyEntity) {
            ((AbstractCompanyEntity)auditingEntity).setMultipleFields(auditingDTO.getMultipleFields());
        } else if (auditingEntity instanceof AbstractMpCompanyEntity) {
            ((AbstractMpCompanyEntity)auditingEntity).setMultipleFields(auditingDTO.getMultipleFields());
        }
    }

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        String userName;
        UserDetailDO userDO;
        String createdBy = auditingEntity.getCreatedBy();
        auditingDTO.setCreatedName(createdBy);
        String lastModifiedBy = auditingEntity.getLastModifiedBy();
        auditingDTO.setLastModifiedName(lastModifiedBy);
        Boolean lastModifiedSetted = Boolean.FALSE;
        try {
            if (StringUtils.isNumeric((CharSequence)createdBy) && (userDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(createdBy))) != null) {
                userName = userDO.getNameCn();
                auditingDTO.setCreatedName(userName);
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && lastModifiedBy.equals(createdBy)) {
                    auditingDTO.setLastModifiedName(userName);
                    lastModifiedSetted = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        if (!lastModifiedSetted.booleanValue()) {
            try {
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && (userDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(lastModifiedBy))) != null) {
                    userName = userDO.getNameCn();
                    auditingDTO.setLastModifiedName(userName);
                }
            }
            catch (Exception e) {
                logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
        Long companyId = null;
        if (auditingEntity instanceof AbstractCompanyEntity) {
            AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
            if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L) {
                companyId = companyEntity.getCompanyId();
            }
        } else if (null != auditingDTO.getCompanyId()) {
            companyId = auditingDTO.getCompanyId();
        }
        if (null != companyId) {
            try {
                CompanyDO companyDO = this.adminEntityCacheUtils.getCompanyDO(companyId);
                if (companyDO != null) {
                    auditingDTO.setCompanyId(companyDO.getId());
                    auditingDTO.setCompanyCode(companyDO.getCode());
                    auditingDTO.setCompanyName(companyDO.getName());
                }
            }
            catch (Exception e) {
                logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);

    public abstract List<DTO> toDto(Set<Entity> var1);
}

