/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseBeanServiceImpl
implements BaseRpcService {
    @Resource
    private ElsCompanySetService elsCompanySetService;
    @Resource
    private PurchaseAttachmentService purchaseAttachmentService;
    @Resource
    private I18nService i18nService;
    @Resource
    private CodeGeneratorService codeGeneratorService;
    @Resource
    private DictService dictService;

    public String getI18nValue(String i18nKey, String defaultValue) {
        return this.i18nService.getI18nValue(i18nKey, defaultValue);
    }

    public List<ElsCompanySetDTO> getCompanySetList(String elsAccount) {
        List companySetList = this.elsCompanySetService.findList(elsAccount);
        ArrayList<ElsCompanySetDTO> resultList = new ArrayList<ElsCompanySetDTO>();
        for (ElsCompanySetVO setVO : companySetList) {
            ElsCompanySetDTO setDTO = new ElsCompanySetDTO();
            BeanUtils.copyProperties((Object)setVO, (Object)setDTO);
            resultList.add(setDTO);
        }
        return resultList;
    }

    public List<PurchaseAttachmentDTO> getPurchaseAttachmentListByMainId(String mainId) {
        List purchaseAttachmentList = this.purchaseAttachmentService.selectByMainId(mainId);
        ArrayList<PurchaseAttachmentDTO> resultList = new ArrayList<PurchaseAttachmentDTO>();
        for (PurchaseAttachment attachment : purchaseAttachmentList) {
            PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)attachment, (Object)attachmentDTO);
            resultList.add(attachmentDTO);
        }
        return resultList;
    }

    public String getNextCode(String codeType, Object businessObj) {
        return this.codeGeneratorService.getNextCode(codeType, businessObj);
    }

    public List<DictDTO> queryDictItemsByCode(String dictCode, String elsAccount) {
        List dictModelsList = this.dictService.queryDictItemsByCode(dictCode, elsAccount);
        return SysUtil.copyProperties((List)dictModelsList, DictDTO.class);
    }

    public List<String> getNextCodes(String codeType, Object businessObj, int size) {
        return this.codeGeneratorService.getNextCodes(codeType, businessObj, size);
    }
}

