/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.apirecord.entity.ApiCallRecord;
import com.els.modules.apirecord.entity.ApiCountLimit;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.apirecord.service.ApiCallRecordService;
import com.els.modules.apirecord.service.ApiCountLimitService;
import com.els.modules.base.api.service.ApiCallRecordRpcService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiCallRecordRpcServiceImpl
implements ApiCallRecordRpcService {
    @Autowired
    private ApiCallRecordService apiCallRecordService;
    @Autowired
    private ApiCountLimitService apiCountLimitService;
    @Autowired
    private RedisUtil redisUtil;

    public void saveApiCallRecord(String apiCode, String id) {
        ApiCallRecord record = new ApiCallRecord();
        record.setElsAccount(TenantContext.getTenant());
        record.setApiCode(apiCode);
        record.setRelatedId(id);
        record.setCreateTime(new Date());
        LoginUser loginUser = SysUtil.getLoginUser();
        record.setCreateBy(loginUser.getSubAccount());
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCode);
        record.setApiName(apiTypeEnum.getDesc());
        record.setApiCode(apiTypeEnum.getCode());
        record.setApiType(apiTypeEnum.getType());
        this.apiCallRecordService.save((Object)record);
        this.saveCount(record, loginUser.getSubAccount());
    }

    private void saveCount(ApiCallRecord record, String subAccount) {
        Long count = this.redisUtil.incr("api:count:" + subAccount + ":" + record.getApiCode(), 1L);
        ApiCountLimit apiCountLimit = this.apiCountLimitService.getByAccountAndApiCode(record.getCreateBy(), record.getApiCode());
        apiCountLimit.setCount(Integer.valueOf(count.intValue()));
        apiCountLimit.setElsAccount(record.getElsAccount());
        if (ObjectUtil.isEmpty((Object)apiCountLimit.getId())) {
            apiCountLimit.setApiCode(record.getApiCode());
            apiCountLimit.setApiType(record.getApiType());
            apiCountLimit.setCreateBy(subAccount);
            this.apiCountLimitService.save((Object)apiCountLimit);
        } else {
            this.apiCountLimitService.updateById((Object)apiCountLimit);
        }
    }
}

