/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.rpc.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.api.service.InquiryTodoListRpcService;
import com.els.modules.history.entity.ElsBusinessTransferHis;
import com.els.modules.material.api.service.MainDataTodoListRpcService;
import com.els.modules.order.api.service.OrderTodoListRpcService;
import com.els.modules.sample.api.service.OtherTodoListRpcService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.todo.enums.TodoTypeEnum;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.utils.PageUtils;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TodoListSingleServiceImpl
implements TodoListService {
    private static final Logger log = LoggerFactory.getLogger(TodoListSingleServiceImpl.class);
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    @Lazy
    private SupplierTodoListRpcService supplierTodoListRpcService;
    @Resource
    @Lazy
    private MainDataTodoListRpcService mainDataTodoListRpcService;
    @Resource
    @Lazy
    private OrderTodoListRpcService orderTodoListRpcService;
    @Resource
    @Lazy
    private FinanceTodoListRpcService financeTodoListRpcService;
    @Resource
    @Lazy
    private ContractTodoListRpcService contractTodoListRpcService;
    @Resource
    @Lazy
    private OtherTodoListRpcService otherTodoListRpcService;
    @Resource
    @Lazy
    private InquiryTodoListRpcService inquiryTodoListRpcService;
    @Autowired
    private ThreadPoolExecutor srmPoolExecutor;

    public List<TodoCountInfoVO> getTodoCountList() {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return null;
        }
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-start");
        ArrayList<TodoCountInfoVO> resultTodoList = new ArrayList();
        resultTodoList = this.processTodoCountInfo(filterPermissionDTOList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-end");
        return resultTodoList;
    }

    public IPage<ElsBusinessTransferHis> pageTodoCountList(Integer pageNo, Integer pageSize) {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return new Page();
        }
        List pageTodoList = PageUtils.startPage(filterPermissionDTOList, (Integer)pageNo, (Integer)pageSize);
        List<TodoCountInfoVO> resultTodoList = this.processTodoCountInfo(pageTodoList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        Page pageResult = new Page();
        pageResult.setRecords(resultTodoList);
        pageResult.setTotal((long)filterPermissionDTOList.size());
        pageResult.setSize((long)pageSize.intValue());
        pageResult.setPages((long)pageNo.intValue());
        return pageResult;
    }

    private List<PermissionDTO> processPermissionTodoList() {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List permissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList();
        List allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        filterPermissionDTOList = filterPermissionDTOList.parallelStream().sorted(Comparator.comparing(PermissionDTO::getUrl)).collect(Collectors.toList());
        return filterPermissionDTOList;
    }

    private List<TodoCountInfoVO> processTodoCountInfo(List<PermissionDTO> permissionDTOList, String elsAccount, String subAccount) {
        ArrayList<TodoCountInfoVO> todList = new ArrayList<TodoCountInfoVO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            ArrayList<String> statusList;
            TodoStatusVO statusVO2;
            TodoStatusVO statusVO;
            TodoStatusVO statusVO3;
            Integer count;
            ArrayList<String> standardStatusList;
            TodoCountInfoVO vo;
            Integer count2;
            ArrayList<String> standardStatusList2;
            TodoCountInfoVO vo2;
            Integer count1;
            ArrayList<String> standardStatusList1;
            if (TodoTypeEnum.PURCHASE_1.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList<String>();
                standardStatusList1.add("1");
                count1 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u68c0\u67e5\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                if (count1 > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count1);
                    TodoStatusVO statusVO1 = new TodoStatusVO();
                    statusVO1.setName("standardStatus");
                    statusVO1.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO1));
                    vo2.setModuleName(vo2.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_0vq37GDwIYph08SX", (String)"\u68c0\u67e5\u4e2d") + ")");
                    todList.add(vo2);
                }
                standardStatusList2 = new ArrayList<String>();
                standardStatusList2.add("2");
                count2 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u8bc4\u4f30\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    TodoStatusVO statusVO22 = new TodoStatusVO();
                    statusVO22.setName("standardStatus");
                    statusVO22.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO22));
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_zqx3q0dOMWsxx94E", (String)"\u8bc4\u4f30\u4e2d") + ")");
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_2.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList<String>();
                standardStatusList.add("3");
                count = this.supplierTodoListRpcService.countSupplierInfoChangeHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("status");
                    statusVO3.setValue("3");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_3.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.supplierTodoListRpcService.countSupplierAccessMgmtQuareviewHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("quareviewStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_4.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("4");
                count = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("status");
                    statusVO3.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_5_1.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("4");
                count = this.orderTodoListRpcService.countPurchaseOrderItemList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("itemStatus");
                    statusVO3.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_7.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeOrderList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("noticeStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_8.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("noticeStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_9.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.financeTodoListRpcService.countPurchaseOrderHeadSaleRecAffirmStatusList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("0");
                count2 = this.financeTodoListRpcService.countPurchaseOrderHeadPurchaseInvoiceAffirmStatusList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("saleRecAffirmStatus");
                    statusVO.setValue("1");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO, statusVO2));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("purchaseInvoiceAffirmStatus");
                    statusVO.setValue("0");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO, statusVO2));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_9_1.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationSaleRecAffirmStatusList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("0");
                count2 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationPurchaseInvoiceAffirmStatusList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("saleRecAffirmStatus");
                    statusVO.setValue("1");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO, statusVO2));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("purchaseInvoiceAffirmStatus");
                    statusVO.setValue("0");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO, statusVO2));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList<String>();
                statusList.add("1");
                count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("confirmStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_10_1.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("3");
                count = this.financeTodoListRpcService.countPurchaseDeductCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("confirmStatus");
                    statusVO3.setValue("3");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_11.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("contractStatus");
                    statusVO3.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadHisList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("contractStatus");
                    statusVO3.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("rectificationStatus");
                    statusVO3.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_14.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseSampleHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("sampleStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_15.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseMassProdHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("documentsStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_16.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("documentsStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_17.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("0");
                count = this.otherTodoListRpcService.countPurchaseSpcnList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_17.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("purchaseConfirmStatus");
                    statusVO3.setValue("0");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_18.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldMaintainList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_18.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("maintainStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_19.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldScrappedList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("scrappedStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_20.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchasePerformanceDetailReportList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("appealStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_21.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countPurchasePerformanceReportHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("reportStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_22.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.inquiryTodoListRpcService.countPurchaseEnquiryList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_22.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("enquiryStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_23.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("3");
                count2 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("ebiddingStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("ebiddingStatus");
                    statusVO.setValue("3");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_24.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("biddingStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_25.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("3");
                count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_25.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("biddingStatus");
                    statusVO3.setValue("3");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_26.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("0");
                count = this.inquiryTodoListRpcService.countPurchaseQualificationList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_26.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("reviewStatus");
                    statusVO3.setValue("0");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_1.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("quareviewStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_2.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleStandardHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("standardStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_3.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.mainDataTodoListRpcService.countSaleInformationRecordsRequestHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("status");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_4.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleOrderHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("orderStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_5.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("noticeStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_6.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("noticeStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_7.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleRefundsDeliveryHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("refundsDeliveryStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_8.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleReconciliationList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("reconciliationStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_9.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleDeductCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("confirmStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("rectificationStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_11.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleSampleHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("sampleStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleMassProdHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("documentsStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleInspectionHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("documentsStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_14.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleMouldTransferHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("transferStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_15.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.contractTodoListRpcService.countSaleContractHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("contractStatus");
                    statusVO3.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_16.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.contractTodoListRpcService.countSaleContractPromiseList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("promiseStatus");
                    statusVO3.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO3));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_17.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u62a5\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("7");
                count2 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u8bae\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_InQuotation", (String)"\u62a5\u4ef7\u4e2d") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("enquiryStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_Ius_2163644", (String)"\u8bae\u4ef7\u4e2d") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("enquiryStatus");
                    statusVO.setValue("7");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_18.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("3");
                count2 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("ebiddingStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
                    statusVO = new TodoStatusVO();
                    statusVO.setName("ebiddingStatus");
                    statusVO.setValue("3");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (!TodoTypeEnum.SUPPLIER_19.getUrl().equals(permissionDTO.getUrl())) continue;
            statusList = new ArrayList();
            statusList.add("1");
            count = this.inquiryTodoListRpcService.countSaleBiddingList(elsAccount, statusList);
            log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
            if (count <= 0) continue;
            vo2 = this.processTodoInfo(permissionDTO, count);
            statusVO3 = new TodoStatusVO();
            statusVO3.setName("biddingStatus");
            statusVO3.setValue("1");
            vo2.setStatusList(Arrays.asList(statusVO3));
            todList.add(vo2);
        }
        return todList;
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        vo.setModuleName(I18nUtil.translate((String)permissionDTO.getNameI18nKey(), (String)permissionDTO.getName()));
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }
}

