/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.base.entity.ElsStatusLog;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.base.api.dto.CompanyInterfaceConfigDTO;
import com.els.modules.base.api.dto.CompanyInterfaceConfigItemDTO;
import com.els.modules.base.api.dto.ConnectorConfigDTO;
import com.els.modules.base.api.dto.ConnectorFieldMappingDTO;
import com.els.modules.base.api.dto.ConnectorInterfaceDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsBusinessRuleDTO;
import com.els.modules.base.api.dto.ElsCompanyLanguageDTO;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.base.api.dto.ElsStatusLogDTO;
import com.els.modules.base.api.dto.ElsSystemSetDTO;
import com.els.modules.base.api.dto.EnhanceConfigDTO;
import com.els.modules.base.api.dto.I18nDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SensitiveFieldDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.language.service.ElsCompanyLanguageService;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.CompanyInterfaceConfig;
import com.els.modules.system.entity.CompanyInterfaceConfigItem;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.entity.ElsSystemSet;
import com.els.modules.system.entity.EnhanceConfig;
import com.els.modules.system.service.BackgroundFileTaskService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.CompanyInterfaceConfigItemService;
import com.els.modules.system.service.CompanyInterfaceConfigService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanyBusinessRuleService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsStatusLogService;
import com.els.modules.system.service.ElsSystemSetService;
import com.els.modules.system.service.EnhanceConfigService;
import com.els.modules.system.service.SensitiveFieldService;
import com.els.modules.system.vo.ElsCompanyBusinessRuleVO;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.service.ConnectorConfigService;
import com.els.modules.third.service.ConnectorFieldMappingService;
import com.els.modules.third.service.ConnectorInterfaceService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseBeanServiceImpl
implements BaseRpcService {
    @Resource
    private ElsCompanySetService elsCompanySetService;
    @Resource
    private ElsSystemSetService elsSystemSetService;
    @Resource
    private ElsCompanyBusinessRuleService elsCompanyBusinessRuleService;
    @Resource
    private PurchaseAttachmentService purchaseAttachmentService;
    @Resource
    private I18nService i18nService;
    @Resource
    private CodeGeneratorService codeGeneratorService;
    @Resource
    private DictService dictService;
    @Resource
    private ElsStatusLogService elsStatusLogService;
    @Resource
    private ElsCompanyLanguageService elsCompanyLanguageService;
    @Resource
    private CompanyInterfaceConfigService companyInterfaceConfigService;
    @Resource
    private CompanyInterfaceConfigItemService companyInterfaceConfigItemService;
    @Resource
    private SensitiveFieldService sensitiveFieldService;
    @Resource
    private EnhanceConfigService enhanceConfigService;
    @Resource
    private BackgroundFileTaskService backgroundFileTaskService;
    @Resource
    private ConnectorConfigService connectorConfigService;
    @Resource
    private ConnectorFieldMappingService connectorFieldMappingService;
    @Resource
    private ConnectorInterfaceService connectorInterfaceService;

    public void translate() {
        this.i18nService.translateAll();
    }

    public String getI18nValue(String i18nKey, String defaultValue) {
        return this.i18nService.getI18nValue(i18nKey, defaultValue);
    }

    public JSONObject findAllListCache(String tenant, String language) {
        return this.i18nService.findAllListCache(tenant, language);
    }

    public List<I18nDTO> findI18Key(String tenant, String i18Key) {
        return this.i18nService.findI18Key(tenant, i18Key);
    }

    public List<ElsCompanySetDTO> getCompanySetList(String elsAccount) {
        List companySetList = this.elsCompanySetService.findList(elsAccount);
        ArrayList<ElsCompanySetDTO> resultList = new ArrayList<ElsCompanySetDTO>();
        for (ElsCompanySetVO setVO : companySetList) {
            ElsCompanySetDTO setDTO = new ElsCompanySetDTO();
            BeanUtils.copyProperties((Object)setVO, (Object)setDTO);
            resultList.add(setDTO);
        }
        return resultList;
    }

    public List<ElsBusinessRuleDTO> getBusinessRuletList(String elsAccount) {
        List companySetList = this.elsCompanyBusinessRuleService.findByElsAccount(elsAccount);
        ArrayList<ElsBusinessRuleDTO> resultList = new ArrayList<ElsBusinessRuleDTO>();
        for (ElsCompanyBusinessRuleVO setVO : companySetList) {
            ElsBusinessRuleDTO setDTO = new ElsBusinessRuleDTO();
            BeanUtils.copyProperties((Object)setVO, (Object)setDTO);
            resultList.add(setDTO);
        }
        return resultList;
    }

    public ElsBusinessRuleDTO getBusinessRule(String elsAccount, String businessType, String itemCode) {
        ElsBusinessRuleDTO setDTO = null;
        ElsCompanyBusinessRuleVO ruleVO = this.elsCompanyBusinessRuleService.findByElsAccountAndBusinessTypeAndItemCode(elsAccount, businessType, itemCode);
        if (ruleVO != null) {
            setDTO = new ElsBusinessRuleDTO();
            BeanUtils.copyProperties((Object)ruleVO, (Object)setDTO);
        }
        return setDTO;
    }

    public List<PurchaseAttachmentDTO> getPurchaseAttachmentListByMainId(String mainId) {
        List purchaseAttachmentList = this.purchaseAttachmentService.selectByMainId(mainId);
        ArrayList<PurchaseAttachmentDTO> resultList = new ArrayList<PurchaseAttachmentDTO>();
        for (PurchaseAttachment attachment : purchaseAttachmentList) {
            PurchaseAttachmentDTO attachmentDTO = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)attachment, (Object)attachmentDTO);
            resultList.add(attachmentDTO);
        }
        return resultList;
    }

    public String getNextCode(String codeType, Object businessObj) {
        return this.codeGeneratorService.getNextCode(codeType, businessObj);
    }

    public String getNextCode(String codeType, Object businessObj, String elsAccount) {
        return this.codeGeneratorService.getNextCode(codeType, businessObj, elsAccount);
    }

    public List<DictDTO> queryDictItemsByCode(String dictCode, String elsAccount) {
        List dictModelsList = this.dictService.queryDictItemsByCode(dictCode, elsAccount);
        return SysUtil.copyProperties((List)dictModelsList, DictDTO.class);
    }

    public String checkAndAdd(String value) {
        return this.i18nService.checkAndAdd(value);
    }

    public String checkAndAdd(String value, String type) {
        return this.i18nService.checkAndAdd(value, type);
    }

    public Map<String, String> checkAndAdd(List<String> value) {
        return this.i18nService.checkAndAdd(value);
    }

    public Map<String, String> checkAndAdd(List<String> value, String type) {
        return this.i18nService.checkAndAdd(value, type);
    }

    public List<ElsCompanyLanguageDTO> getAuthLanguage(List<String> elsAccounts) {
        List authLanguage = this.elsCompanyLanguageService.getAuthLanguage(elsAccounts);
        return SysUtil.copyProperties((List)authLanguage, ElsCompanyLanguageDTO.class);
    }

    public void addStatusLog(String businessId, String status, String businessType, String operateType) {
        this.elsStatusLogService.addStatusLog(businessId, status, businessType, operateType);
    }

    public List<ElsStatusLogDTO> listStatusLog(String businessId) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsStatusLogService.lambdaQuery().eq(ElsStatusLog::getBusinessId, (Object)businessId)).orderByAsc(ElsStatusLog::getStatusDate)).list();
        return SysUtil.copyProperties((List)list, ElsStatusLogDTO.class);
    }

    public Map<String, String> translateLanguage(List<ElsCompanyLanguageDTO> elsCompanyLanguageDTOList) {
        return this.i18nService.translateLanguage(elsCompanyLanguageDTOList);
    }

    public List<String> getNextCodes(String codeType, Object businessObj, int size) {
        return this.codeGeneratorService.getNextCodes(codeType, businessObj, size);
    }

    public CompanyInterfaceConfigDTO getCompanyInterfaceConfigByCode(String elsAccount, String srmInterfaceCode) {
        CompanyInterfaceConfig config = this.companyInterfaceConfigService.getOneConfig(elsAccount, srmInterfaceCode);
        if (config == null) {
            return null;
        }
        CompanyInterfaceConfigDTO configDTO = new CompanyInterfaceConfigDTO();
        BeanUtils.copyProperties((Object)config, (Object)configDTO);
        return configDTO;
    }

    public CompanyInterfaceConfigDTO getCompanyInterfaceConfigByCode(String elsAccount, String srmInterfaceCode, String companyCode) {
        CompanyInterfaceConfigItem config = this.companyInterfaceConfigItemService.getOneConfig(elsAccount, srmInterfaceCode, companyCode);
        if (config == null) {
            return null;
        }
        CompanyInterfaceConfigDTO configDTO = new CompanyInterfaceConfigDTO();
        BeanUtils.copyProperties((Object)config, (Object)configDTO);
        return configDTO;
    }

    public List<SensitiveFieldDTO> findSensitiveFieldByGroup(String elsAccount, String groups) {
        List fieldList = this.sensitiveFieldService.findSensitiveFieldByGroup(elsAccount, groups);
        return SysUtil.copyProperties((List)fieldList, SensitiveFieldDTO.class);
    }

    public EnhanceConfigDTO findEnhanceConfig(String elsAccount, String enhancePoint) {
        EnhanceConfig config = this.enhanceConfigService.findEnhanceConfig(elsAccount, enhancePoint);
        if (config == null) {
            return null;
        }
        EnhanceConfigDTO configDTO = new EnhanceConfigDTO();
        BeanUtils.copyProperties((Object)config, (Object)configDTO);
        return configDTO;
    }

    public List<CompanyInterfaceConfigItemDTO> getConfig(String elsAccount, String srmInterfaceCode) {
        List configItemList = this.companyInterfaceConfigItemService.getConfig(elsAccount, srmInterfaceCode);
        return SysUtil.copyProperties((List)configItemList, CompanyInterfaceConfigItemDTO.class);
    }

    public Map<String, List<PurchaseAttachmentDTO>> listPurchaseAttachmentListByMainId(List<String> headIds) {
        if (CollectionUtil.isEmpty(headIds)) {
            return Maps.newHashMap();
        }
        return this.purchaseAttachmentService.listPurchaseAttachmentListByMainId(headIds);
    }

    public List<DictDTO> findOpenbusinessType() {
        List dictItems = this.dictService.findOpenbusinessType();
        return dictItems.stream().map(x -> {
            DictDTO dictDTO = new DictDTO();
            dictDTO.setKey(x.getItemValue());
            dictDTO.setValue(x.getItemValue());
            dictDTO.setText(x.getItemText());
            dictDTO.setTextI18nKey(x.getItemTextI18nKey());
            dictDTO.setDescription(x.getDescription());
            return dictDTO;
        }).collect(Collectors.toList());
    }

    public List<I18nDTO> initI18Key() {
        List list = this.i18nService.initI18Key();
        return Convert.toList(I18nDTO.class, (Object)list);
    }

    public ElsSystemSetDTO getElsSystemSetByElsAccountAndItemCode(String elsAccount, String itemCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"item_code", (Object)itemCode);
        List list = this.elsSystemSetService.list((Wrapper)queryWrapper);
        ElsSystemSetDTO elsSystemSetDTO = new ElsSystemSetDTO();
        if (!list.isEmpty() && list.size() > 0) {
            ElsSystemSet elsSystemSet = (ElsSystemSet)list.get(0);
            BeanUtils.copyProperties((Object)elsSystemSet, (Object)elsSystemSetDTO);
        }
        return elsSystemSetDTO;
    }

    public ElsCompanySetDTO getElsCompanySetByElsAccountAndItemCode(String elsAccount, String itemCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"item_code", (Object)itemCode);
        List list = this.elsCompanySetService.list((Wrapper)queryWrapper);
        ElsCompanySetDTO elsCompanySetDTO = new ElsCompanySetDTO();
        if (!list.isEmpty() && list.size() > 0) {
            ElsCompanySet elsCompanySet = (ElsCompanySet)list.get(0);
            BeanUtils.copyProperties((Object)elsCompanySet, (Object)elsCompanySetDTO);
        }
        return elsCompanySetDTO;
    }

    public void addElsCompanySet(ElsCompanySetDTO elsCompanySetDTO) {
        ElsCompanySet elsCompanySet = new ElsCompanySet();
        BeanUtils.copyProperties((Object)elsCompanySetDTO, (Object)elsCompanySet);
        this.elsCompanySetService.save((Object)elsCompanySet);
    }

    public void saveImportErrorTask(String excelBusinessOptType, String excelBusinessOptTypeName, String id, String elsAccount) {
        this.backgroundFileTaskService.saveImportTask(excelBusinessOptType, excelBusinessOptTypeName, id, elsAccount);
    }

    public void putI18nToRedis(String i18Key) {
        this.i18nService.putI18nToRedis(i18Key);
    }

    public ConnectorConfigDTO loadConnectorConfig(String connectorConfigId) {
        ConnectorConfig config = (ConnectorConfig)this.connectorConfigService.getById((Serializable)((Object)connectorConfigId));
        if (null == config) {
            return null;
        }
        return (ConnectorConfigDTO)Convert.convert(ConnectorConfigDTO.class, (Object)config);
    }

    public ConnectorConfigDTO loadConnectorConfig(String elsAccount, String systemCode, String systemVersion) {
        ConnectorConfig connectorConfig = this.connectorConfigService.loadConnectorConfig(elsAccount, systemCode, systemVersion);
        if (null == connectorConfig) {
            return null;
        }
        return (ConnectorConfigDTO)Convert.convert(ConnectorConfigDTO.class, (Object)connectorConfig);
    }

    public List<ConnectorFieldMappingDTO> findByElsAccountAndSrmInterfaceCode(String elsAccount, String srmInterfaceCode, String headId) {
        return this.connectorFieldMappingService.findByElsAccountAndSrmInterfaceCode(elsAccount, srmInterfaceCode, headId);
    }

    public List<ConnectorFieldMappingDTO> findByElsAccountAndSrmInterfaceCode(String elsAccount, String srmInterfaceCode, String beanName, String headId) {
        return this.connectorFieldMappingService.findByElsAccountAndSrmInterfaceCode(elsAccount, srmInterfaceCode, beanName, headId);
    }

    public List<ConnectorFieldMappingDTO> findByElsAccountAndSrmInterfaceCodeAndTable(String elsAccount, String srmInterfaceCode, String mappingTable, String headId) {
        return this.connectorFieldMappingService.findByElsAccountAndSrmInterfaceCodeAndTable(elsAccount, srmInterfaceCode, mappingTable, headId);
    }

    public ConnectorInterfaceDTO loadConnectorInterface(String elsAccount, String systemCode, String systemVersion, String srmInterfaceCode, String interfaceCode) {
        return this.connectorInterfaceService.loadConnectorInterface(elsAccount, systemCode, systemVersion, srmInterfaceCode, interfaceCode);
    }

    public List<ConnectorFieldMappingDTO> findConnectorFieldMappingByHeadId(String interfaceId, String mappingTable) {
        return this.connectorFieldMappingService.findConnectorFieldMappingByHeadId(interfaceId, mappingTable);
    }
}

