/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.rpc.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.api.service.InquiryTodoListRpcService;
import com.els.modules.history.entity.ElsBusinessTransferHis;
import com.els.modules.material.api.service.MainDataTodoListRpcService;
import com.els.modules.order.api.service.OrderTodoListRpcService;
import com.els.modules.sample.api.service.OtherTodoListRpcService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.todo.enums.TodoTypeEnum;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.utils.PageUtils;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TodoListSingleServiceImpl
implements TodoListService {
    private static final Logger log = LoggerFactory.getLogger(TodoListSingleServiceImpl.class);
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    @Lazy
    private SupplierTodoListRpcService supplierTodoListRpcService;
    @Resource
    @Lazy
    private MainDataTodoListRpcService mainDataTodoListRpcService;
    @Resource
    @Lazy
    private OrderTodoListRpcService orderTodoListRpcService;
    @Resource
    @Lazy
    private FinanceTodoListRpcService financeTodoListRpcService;
    @Resource
    @Lazy
    private ContractTodoListRpcService contractTodoListRpcService;
    @Resource
    @Lazy
    private OtherTodoListRpcService otherTodoListRpcService;
    @Resource
    @Lazy
    private InquiryTodoListRpcService inquiryTodoListRpcService;
    @Autowired
    private ThreadPoolExecutor srmPoolExecutor;
    @Autowired
    private PermissionDataQueryUtil permissionDataQueryUtil;

    public List<TodoCountInfoVO> getTodoCountList() {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return null;
        }
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-start");
        ArrayList<TodoCountInfoVO> resultTodoList = new ArrayList();
        resultTodoList = this.processTodoCountInfo(filterPermissionDTOList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-end");
        return resultTodoList;
    }

    public IPage<ElsBusinessTransferHis> pageTodoCountList(Integer pageNo, Integer pageSize) {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return new Page();
        }
        List pageTodoList = PageUtils.startPage(filterPermissionDTOList, (Integer)pageNo, (Integer)pageSize);
        List<TodoCountInfoVO> resultTodoList = this.processTodoCountInfo(pageTodoList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        Page pageResult = new Page();
        pageResult.setRecords(resultTodoList);
        pageResult.setTotal((long)filterPermissionDTOList.size());
        pageResult.setSize((long)pageSize.intValue());
        pageResult.setPages((long)pageNo.intValue());
        return pageResult;
    }

    private List<PermissionDTO> processPermissionTodoList() {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List permissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList();
        List allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        filterPermissionDTOList = filterPermissionDTOList.parallelStream().sorted(Comparator.comparing(PermissionDTO::getUrl)).collect(Collectors.toList());
        return filterPermissionDTOList;
    }

    private List<TodoCountInfoVO> processTodoCountInfo(List<PermissionDTO> permissionDTOList, String elsAccount, String subAccount) {
        ArrayList<TodoCountInfoVO> todList = new ArrayList<TodoCountInfoVO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            this.processPurchaseTodoList(elsAccount, subAccount, todList, permissionDTO);
            this.processSupplierTodoList(elsAccount, subAccount, todList, permissionDTO);
        }
        return todList;
    }

    private void processPurchaseTodoList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        if (TodoTypeEnum.PURCHASE_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseStandardHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSupplierInfoChangeHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_3.getUrl().equals(permissionDTO.getUrl())) {
            this.countSupplierAccessMgmtQuareviewHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_4.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseInformationRecordsRequestHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_5_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseOrderItemList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_7.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeliveryNoticeOrderList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_8.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeliveryNoticeList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_9.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseOrderHeadSaleRecList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_9_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceReconciliationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_10.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseAddCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_10_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeductCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_11.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseContractHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_12.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseContractHeadHisList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_13.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSupplierRectificationReportHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_14.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSampleHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_15.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMassProdHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_16.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseInspectionHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_17.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSpcnList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_18.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMouldMaintainList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_19.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMouldScrappedList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_20.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceDetailReportList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_21.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceReportHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_22.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseEnquiryList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_23.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseEbiddingList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_24.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseBiddingHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_25.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseeValuationOfBidList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_26.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseQualificationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_28.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSurveyItemList(elsAccount, todList, permissionDTO);
        }
    }

    private String getAccountBusinessType(String businessType) {
        String accountBusinessType = null;
        if (StringUtils.isNotBlank((CharSequence)businessType)) {
            accountBusinessType = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount() + "-" + businessType;
        }
        return accountBusinessType;
    }

    private void countPurchaseStandardHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchase_standard");
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u68c0\u67e5\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            TodoStatusVO statusVO1 = new TodoStatusVO();
            statusVO1.setName("standardStatus");
            statusVO1.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO1));
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_0vq37GDwIYph08SX", (String)"\u68c0\u67e5\u4e2d") + ")");
            todList.add(vo);
        }
        this.getAccountBusinessType("purchase_standard");
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("2");
        Integer count2 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u8bc4\u4f30\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("standardStatus");
            statusVO2.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO2));
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_zqx3q0dOMWsxx94E", (String)"\u8bc4\u4f30\u4e2d") + ")");
            todList.add(vo);
        }
    }

    private void countPurchaseSurveyItemList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("survey");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countPurchaseQualificationList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_28.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("answerStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSupplierInfoChangeHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("3");
        Integer count = this.supplierTodoListRpcService.countSupplierInfoChangeHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.supplierTodoListRpcService.countSupplierAccessMgmtQuareviewHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("quareviewStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseInformationRecordsRequestHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("4");
        Integer count = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseOrderItemList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("4");
        Integer count = this.orderTodoListRpcService.countPurchaseOrderItemList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("itemStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeliveryNoticeOrderList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeOrderList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeliveryNoticeList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseOrderHeadSaleRecList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO2;
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType("reconciliation");
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.financeTodoListRpcService.countPurchaseOrderHeadSaleRecAffirmStatusList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        this.getAccountBusinessType("reconciliation");
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("0");
        Integer count2 = this.financeTodoListRpcService.countPurchaseOrderHeadPurchaseInvoiceAffirmStatusList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("saleRecAffirmStatus");
            statusVO.setValue("1");
            statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("purchaseInvoiceAffirmStatus");
            statusVO.setValue("0");
            statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceReconciliationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO2;
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationSaleRecAffirmStatusList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("0");
        Integer count2 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationPurchaseInvoiceAffirmStatusList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("saleRecAffirmStatus");
            statusVO.setValue("1");
            statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("purchaseInvoiceAffirmStatus");
            statusVO.setValue("0");
            statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
    }

    private void countPurchaseAddCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("addCost");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeductCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("deductCost");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("3");
        Integer count = this.financeTodoListRpcService.countPurchaseDeductCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseContractHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("contract");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.contractTodoListRpcService.countPurchaseContractHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseContractHeadHisList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("contract");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.contractTodoListRpcService.countPurchaseContractHeadHisList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSupplierRectificationReportHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("supplierRetification");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSampleHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("sample");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseSampleHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("sampleStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMassProdHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("massProdHead");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseMassProdHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseInspectionHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("siteInspection");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSpcnList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.otherTodoListRpcService.countPurchaseSpcnList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_17.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("purchaseConfirmStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMouldMaintainList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseMouldMaintain");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchaseMouldMaintainList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_18.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("maintainStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMouldScrappedList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseMouldMaintain");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchaseMouldScrappedList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("scrappedStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceDetailReportList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("performanceReportDeliveryRate");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchasePerformanceDetailReportList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("appealStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceReportHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("performanceReport");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countPurchasePerformanceReportHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("reportStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseEnquiryList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("enquiry");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countPurchaseEnquiryList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_22.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseEbiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType("ebidding");
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("3");
        Integer count2 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseBiddingHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bidding");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseeValuationOfBidList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bidding");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("3");
        Integer count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_25.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseQualificationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseQualificationReview");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countPurchaseQualificationList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_26.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("reviewStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void processSupplierTodoList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        if (TodoTypeEnum.SUPPLIER_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleStandardHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_3.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleInformationRecordsRequestHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_4.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleOrderHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_5.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeliveryNoticeByOrderList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_6.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeliveryNoticeList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_7.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleRefundsDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_8.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleReconciliationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_9.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeductCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_10.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSupplierRectificationReportHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_11.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSampleHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_12.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleMassProdHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_13.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleInspectionHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_14.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleMouldTransferHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_15.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleContractHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_16.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleContractPromiseList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_17.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleEnquiryList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_18.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleEbiddingList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_19.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleBiddingList(elsAccount, todList, permissionDTO);
        }
    }

    private void countSaleSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("quareviewStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleStandardHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countSaleStandardHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("standardStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleInformationRecordsRequestHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.mainDataTodoListRpcService.countSaleInformationRecordsRequestHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleOrderHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleOrderHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("orderStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeliveryNoticeByOrderList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeliveryNoticeList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleRefundsDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleRefundsDeliveryHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("refundsDeliveryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleReconciliationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countSaleReconciliationList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("reconciliationStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeductCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countSaleDeductCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSupplierRectificationReportHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleSupplierRectificationReportHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSampleHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleSampleHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("sampleStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleMassProdHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleMassProdHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleInspectionHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleInspectionHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleMouldTransferHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleMouldTransferHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("transferStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleContractHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.contractTodoListRpcService.countSaleContractHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleContractPromiseList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.contractTodoListRpcService.countSaleContractPromiseList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleEnquiryList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u62a5\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("7");
        Integer count2 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u8bae\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_InQuotation", (String)"\u62a5\u4ef7\u4e2d") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_Ius_2163644", (String)"\u8bae\u4ef7\u4e2d") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("7");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleEbiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("3");
        Integer count2 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleBiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countSaleBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        vo.setModuleName(I18nUtil.translate((String)permissionDTO.getNameI18nKey(), (String)permissionDTO.getName()));
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }
}

