/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.service.ElsTaxService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="findColumnByTaxConverter")
public class FindColumnByTaxConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(FindColumnByTaxConverter.class);
    private static final String REDIS_PREFIX = "srm:getTaxConver";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsTaxService taxService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String dictCode = args[0];
        String searColumn = args[1];
        String outColumn = args[2];
        if (StringUtils.isNotBlank((CharSequence)searData)) {
            Map<String, ElsTax> dbMap;
            List elsTaxes = (List)this.redisUtil.get(REDIS_PREFIX + elsAccount + ":" + dictCode);
            if (CollectionUtils.isEmpty((Collection)elsTaxes)) {
                elsTaxes = ((LambdaQueryChainWrapper)this.taxService.lambdaQuery().select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxName, ElsTax::getTaxRate}).eq(BaseEntity::getElsAccount, (Object)elsAccount)).list();
                if (CollectionUtils.isEmpty((Collection)elsTaxes)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)elsTaxes, 300L);
            }
            if ((dbMap = this.getSearKeyMap(searColumn, JSON.parseArray((String)JSON.toJSONString((Object)elsTaxes)))).containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }

    private Map<String, ElsTax> getSearKeyMap(String searColumn, JSONArray arrays) {
        HashMap<String, ElsTax> result = new HashMap<String, ElsTax>();
        for (int i = 0; i < arrays.size(); ++i) {
            JSONObject obj = arrays.getJSONObject(i);
            if (!obj.containsKey((Object)searColumn)) continue;
            String key = obj.getString(searColumn);
            result.put(key, (ElsTax)JSON.parseObject((String)obj.toJSONString(), ElsTax.class));
        }
        return result;
    }
}

