/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="findColumnByDictConverter")
public class FindColumnByDictConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(FindColumnByDictConverter.class);
    private static final String REDIS_PREFIX = "srm:getTaxConver";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private DictService dictService;
    private DictItemService dictItemService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String dictCode = args[0];
        String searColumn = args[1];
        String outColumn = args[2];
        if (StringUtils.isNotBlank((CharSequence)searData)) {
            Map<String, DictItem> dbMap;
            List dbAccount = (List)this.redisUtil.get(REDIS_PREFIX + elsAccount + ":" + dictCode);
            if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                dbAccount = this.dictService.findByDictCode(elsAccount, dictCode);
                if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)dbAccount, 300L);
            }
            if ((dbMap = this.getSearKeyMap(searColumn, JSON.parseArray((String)JSON.toJSONString((Object)dbAccount)))).containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }

    private Map<String, DictItem> getSearKeyMap(String searColumn, JSONArray arrays) {
        HashMap<String, DictItem> result = new HashMap<String, DictItem>();
        for (int i = 0; i < arrays.size(); ++i) {
            JSONObject obj = arrays.getJSONObject(i);
            if (searColumn.indexOf("_") > 0) {
                String[] columns = searColumn.split("_");
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < columns.length; ++j) {
                    sb.append(obj.getString(columns[j]));
                    if (j == columns.length - 1) continue;
                    sb.append("_");
                }
                result.put(sb.toString(), (DictItem)JSON.parseObject((String)obj.toJSONString(), DictItem.class));
                continue;
            }
            if (!obj.containsKey((Object)searColumn)) continue;
            String key = obj.getString(searColumn);
            result.put(key, (DictItem)JSON.parseObject((String)obj.toJSONString(), DictItem.class));
        }
        return result;
    }
}

