/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateGroupDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateGroupHis;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupHisService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateBeanServiceImpl
implements TemplateRpcService {
    @Resource
    private TemplateHeadService templateHeadService;
    @Resource
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Resource
    private TemplateGroupHisService templateGroupHisService;
    @Resource
    private TemplateConfigItemService templateConfigItemService;

    public Map<String, String> getHeadDictMap(String elsAccount, String templateNumber, String templateVersion) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        return headVO.getTemplateConfigHeadList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDictCode, (newVal, oldVal) -> oldVal));
    }

    public Map<String, String> getItemDictMap(String elsAccount, String templateNumber, String templateVersion) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        return headVO.getTemplateConfigItemList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).collect(Collectors.toMap(TemplateConfigItem::getFieldName, TemplateConfigItem::getDictCode, (newVal, oldVal) -> oldVal));
    }

    public Map<String, String> getHeadDictMap(String elsAccount, String templateNumber, String templateVersion, String groupCode) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        return headVO.getTemplateConfigHeadList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).filter(config -> StrUtil.isBlank((CharSequence)groupCode) || groupCode.equals(config.getGroupCode())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDictCode, (newVal, oldVal) -> oldVal));
    }

    public Map<String, String> getItemDictMap(String elsAccount, String templateNumber, String templateVersion, String groupCode) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        return headVO.getTemplateConfigItemList().stream().filter(config -> StrUtil.isNotBlank((CharSequence)config.getDictCode())).filter(config -> StrUtil.isBlank((CharSequence)groupCode) || groupCode.equals(config.getGroupCode())).collect(Collectors.toMap(TemplateConfigItem::getFieldName, TemplateConfigItem::getDictCode, (newVal, oldVal) -> oldVal));
    }

    public List<TemplateHeadDTO> getDefaultTemplateByType(String businessType) {
        List heads = this.templateHeadService.getDefaultTemplateByType(businessType);
        if (!heads.isEmpty()) {
            return SysUtil.copyProperties((List)heads, TemplateHeadDTO.class);
        }
        return null;
    }

    public List<TemplateConfigHeadDTO> selectByMainId(String id) {
        List configHeads = this.templateConfigHeadService.selectByMainId(id);
        if (!configHeads.isEmpty()) {
            return SysUtil.copyProperties((List)configHeads, TemplateConfigHeadDTO.class);
        }
        return null;
    }

    public Map<String, String> getDefaultValueMap(String elsAccount, String templateNumber, String templateVersion) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        Map<String, String> defaultMap = headVO.getTemplateConfigHeadList().stream().filter(head -> StrUtil.isNotBlank((CharSequence)head.getDefaultValue())).collect(Collectors.toMap(TemplateConfigHead::getFieldName, TemplateConfigHead::getDefaultValue));
        return defaultMap;
    }

    public List<TemplateHeadDTO> getAllByAccountAndType(String elsAccount, String businessType) {
        List headList = this.templateHeadService.getAllByAccountAndType(elsAccount, businessType);
        return SysUtil.copyProperties((List)headList, TemplateHeadDTO.class);
    }

    public TemplateHeadDTO getById(String id) {
        TemplateHead head = (TemplateHead)this.templateHeadService.getById((Serializable)((Object)id));
        if (head != null) {
            return (TemplateHeadDTO)SysUtil.copyProperties((Object)head, TemplateHeadDTO.class);
        }
        return null;
    }

    public List<Map<String, String>> getColumnByNumber(String templateNumber, int templateVersion) {
        return this.templateGroupService.getColumnByNumber(templateNumber, Integer.valueOf(templateVersion));
    }

    public TemplateHeadDTO getConfig(String elsAccount, String templateNumber, String templateVersion) {
        TemplateHeadVO headVO = this.templateHeadService.getAllConfig(elsAccount, templateNumber, templateVersion);
        TemplateHeadDTO headDTO = (TemplateHeadDTO)Convert.convert(TemplateHeadDTO.class, (Object)headVO);
        List list = this.templateGroupService.selectByMainId(headVO.getId());
        if (list.isEmpty()) {
            ArrayList<TemplateGroup> groupList = new ArrayList<TemplateGroup>();
            List hisList = this.templateGroupHisService.selectByMainId(headVO.getId());
            for (TemplateGroupHis his : hisList) {
                TemplateGroup group = new TemplateGroup();
                BeanUtils.copyProperties((Object)his, (Object)group);
                groupList.add(group);
            }
            headDTO.setTemplateGroupList(Convert.toList(TemplateGroupDTO.class, groupList));
        } else {
            headDTO.setTemplateGroupList(Convert.toList(TemplateGroupDTO.class, (Object)list));
        }
        return headDTO;
    }

    public List<TemplateConfigItemDTO> selectNumberVersionAndCode(String numberVersion, String itemGroupCode, String elsAccount) {
        List templateConfigItems = this.templateConfigItemService.selectNumberVersionAndCode(numberVersion, itemGroupCode, elsAccount);
        return Convert.toList(TemplateConfigItemDTO.class, (Object)templateConfigItems);
    }

    public TemplateHeadDTO selectVoById(String templateId) {
        TemplateHeadVO vo = this.templateHeadService.selectVoById(templateId);
        return (TemplateHeadDTO)Convert.convert(TemplateHeadDTO.class, (Object)vo);
    }

    public List<TemplateHeadDTO> getTemplateByType(String order) {
        List heads = this.templateHeadService.getTemplateByType(order);
        if (!heads.isEmpty()) {
            return SysUtil.copyProperties((List)heads, TemplateHeadDTO.class);
        }
        return null;
    }
}

