/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.global.api.service.impl;

import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.service.BarcodeSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="baseImUserRecordRpcService")
public class BaseBeanImUserRecordRpcService
implements ImUserRecordRpcService {
    @Resource
    private PurchaseBarcodeInfoHeadService purchaseBarcodeInfoHeadService;
    @Resource
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Resource
    private BarcodeSupplierListService barcodeSupplierListService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.PURCHASE_BARCODE_INFO_HEAD.getValue().equals(imRecordDto.getType())) {
            PurchaseBarcodeInfoHead dbHead = (PurchaseBarcodeInfoHead)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            List supplierList = this.barcodeSupplierListService.selectByMainId(imRecordDto.getRecordId());
            return supplierList.stream().map(supplier -> {
                String toElsAccount = supplier.getToElsAccount();
                String subAccount = StringUtils.isEmpty((Object)supplier.getSupplierPrincipal()) ? "1001" : supplier.getSupplierPrincipal().split("_")[0];
                ImUserDTO imUserDTO = new ImUserDTO();
                imUserDTO.setElsAccount(toElsAccount + "_" + subAccount);
                return imUserDTO;
            }).distinct().collect(Collectors.toList());
        }
        if (ImRecordTypeEnum.SALE_BARCODE_INFO_HEAD.getValue().equals(imRecordDto.getType())) {
            SaleBarcodeInfoHead dbHead = (SaleBarcodeInfoHead)this.saleBarcodeInfoHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n__rItWWWWxMK_f5ab9c91", (String)"\u8be5\u8ba2\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getUpdateBy();
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

