/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.dto.OpenApiExtendDTO;
import com.els.modules.extend.api.dto.TemplateHeadDTO;
import com.els.modules.extend.api.service.OpenApiExtendService;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateHeadService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiBeanServiceImpl
implements OpenApiExtendService {
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;

    public OpenApiExtendDTO preInvokeVerify(JSONObject param, String businessType, String headName, String itemName, boolean multipleForm) {
        TemplateHead templateHead = this.getTemplateHead(businessType);
        List configHeadList = this.templateConfigHeadService.selectByMainId(templateHead.getId());
        List configItemList = this.templateConfigItemService.selectByMainId(templateHead.getId());
        JSONArray array = new JSONArray();
        if (multipleForm) {
            array = param.getJSONArray(headName);
        } else {
            array.add((Object)param.getJSONObject(headName));
        }
        if (null == array || array.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63a5\u53e3param\u53c2\u6570\u4e2d${0}\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{headName}));
        }
        HashMap<String, String> defaultHeadMap = new HashMap<String, String>();
        for (Object configHead : configHeadList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configHead.getDefaultValue())) continue;
            defaultHeadMap.put(configHead.getFieldName(), configHead.getDefaultValue());
        }
        HashMap<String, String> defaultItemMap = new HashMap<String, String>();
        for (TemplateConfigItem configItem : configItemList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configItem.getDefaultValue())) continue;
            defaultItemMap.put(configItem.getFieldName(), configItem.getDefaultValue());
        }
        OpenApiExtendDTO openApiExtendDTO = new OpenApiExtendDTO();
        openApiExtendDTO.setDefaultHeadMap(defaultItemMap);
        openApiExtendDTO.setDefaultItemMap(defaultItemMap);
        TemplateHeadDTO templateHeadDTO = new TemplateHeadDTO();
        BeanUtils.copyProperties((Object)templateHead, (Object)templateHeadDTO);
        openApiExtendDTO.setTemplateHeadDTO(templateHeadDTO);
        this.commonParamCheck(array, openApiExtendDTO, configHeadList, configItemList, headName, itemName, multipleForm);
        return openApiExtendDTO;
    }

    private TemplateHead getTemplateHead(String businessType) {
        List list;
        String elsAccount = TenantContext.getTenant();
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDUiLV_7a9d5083", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        if (StringUtils.isNotBlank((CharSequence)businessType) && businessType.contains("#")) {
            String templateNumber = businessType.split("#")[1];
            list = ((LambdaQueryChainWrapper)this.templateHeadService.lambdaQuery().eq(TemplateHead::getTemplateNumber, (Object)templateNumber)).list();
        } else {
            list = this.templateHeadService.getAllByAccountAndType(elsAccount, businessType);
        }
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return (TemplateHead)list.get(0);
    }

    private void commonParamCheck(JSONArray array, OpenApiExtendDTO openApiExtendDTO, List<TemplateConfigHead> configHeadList, List<TemplateConfigItem> configItemList, String headName, String itemName, boolean multipleForm) {
        List<String> headRequiredFieldList = configHeadList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigHead::getFieldName).collect(Collectors.toList());
        List<String> itemRequiredFieldList = configItemList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigItem::getFieldName).collect(Collectors.toList());
        headRequiredFieldList.removeAll(openApiExtendDTO.getDefaultHeadMap().keySet());
        itemRequiredFieldList.removeAll(openApiExtendDTO.getDefaultItemMap().keySet());
        if (CollUtil.isNotEmpty(headRequiredFieldList)) {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                String headLocation = multipleForm ? headName + "[" + index + "]" : headName;
                this.containAndHaveValueCheck(headRequiredFieldList, head, headLocation);
                String itemLocation = multipleForm ? headName + "[" + index + "]." + itemName + "[%s]" : headName + "." + itemName + "[%s]";
                this.checkItemRequiredParam(head, itemRequiredFieldList, itemName, itemLocation);
            }
        } else {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                String itemLocation = multipleForm ? headName + "[" + index + "]." + itemName + "[%s]" : headName + "." + itemName + "[%s]";
                this.checkItemRequiredParam(head, itemRequiredFieldList, itemName, itemLocation);
            }
        }
    }

    private void checkItemRequiredParam(JSONObject head, List<String> itemRequiredFieldList, String itemName, String location) {
        if (CollUtil.isEmpty(itemRequiredFieldList)) {
            return;
        }
        if (!head.containsKey((Object)itemName)) {
            return;
        }
        JSONArray arrayParam = head.getJSONArray(itemName);
        if (null == arrayParam || arrayParam.isEmpty()) {
            return;
        }
        for (int itemIndex = 0; itemIndex < arrayParam.size(); ++itemIndex) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)arrayParam.get(itemIndex));
            this.containAndHaveValueCheck(itemRequiredFieldList, object, String.format(location, itemIndex));
        }
    }

    private void containAndHaveValueCheck(List<String> requiredFieldNameList, JSONObject object, String location) {
        for (String fieldName : requiredFieldNameList) {
            if (!object.containsKey((Object)fieldName)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)String.format("\u53c2\u6570%s\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5\u53c2\u6570\u5b57\u6bb5:%s", location, fieldName)));
            }
            Object fieldValue = object.get((Object)fieldName);
            boolean flag = null == fieldValue || fieldValue instanceof String && CharSequenceUtil.isBlank((CharSequence)((String)fieldValue));
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)String.format("\u53c2\u6570%s\u5b57\u6bb5:%s\u503c\u4e0d\u80fd\u4e3a\u7a7a", location, fieldName)));
        }
    }
}

