/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ipaas.api.service.impl;

import cn.hutool.core.util.XmlUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.els.modules.extend.api.service.OpenInterfaceApiExtendService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OpenInterfaceApiExtendServiceImpl
implements OpenInterfaceApiExtendService {
    @Value(value="${els.path.log}")
    private String LOG_URL;
    private static final String STR_FORMAT = "yyyyMMdd";
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";

    public JSONObject post(String name, String url, Map<String, String> header, JSONObject body) {
        String result = "";
        result = header == null || header.isEmpty() ? HttpRequest.post((String)url).body(body.toJSONString(), "application/json").execute().body() : ((HttpRequest)HttpRequest.post((String)url).headerMap(header, true)).body(body.toJSONString(), "application/json").execute().body();
        String bodyStr = JSONObject.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        this.log(name, bodyStr, result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> httpCallWebService(String name, String url, String username, String password, StringBuilder soapBuilder, String language) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(500).setSocketTimeout(300000).build();
        httpPost.setConfig(config);
        CloseableHttpResponse response = null;
        try {
            httpPost.setHeader("Content-Type", "text/xml;charset=UTF-8");
            httpPost.setHeader("Accept-Encoding", "gzip,deflate");
            if (username != null) {
                String encodedAuthorizedUser = username + STR_SPLIT + password;
                httpPost.setHeader("Authorization", "Basic " + encodedAuthorizedUser);
            }
            if (language != null) {
                httpPost.setHeader("Accept-Language", language);
            }
            StringEntity stringEntity = new StringEntity(soapBuilder.toString(), StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getEntity() != null) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            HashMap<String, Exception> map = new HashMap<String, Exception>();
            map.put("httpCallWebService_exception", e);
            result = ((Object)map).toString();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {}
        }
        this.log(name, soapBuilder.toString(), result);
        Map resultMap = XmlUtil.xmlToMap((String)result);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String name, String inputBody, String outputBody) {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        File file = new File(this.LOG_URL + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = name + STR_SPLIT + System.currentTimeMillis() + ".log";
        String savePath = file.getPath() + File.separator + fileName;
        FileWriter saveFile = null;
        try {
            saveFile = new FileWriter(savePath);
            saveFile.append("\u8f93\u5165\u62a5\u6587:");
            saveFile.append("\n\n");
            saveFile.append(inputBody);
            saveFile.append("\n\n");
            saveFile.append("\u8f93\u51fa\u62a5\u6587:");
            saveFile.append("\n\n");
            saveFile.append(outputBody);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                saveFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

