/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.rpc.service;

import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.extend.api.service.material.PurchaseSafetyStockTodoListExtendRpcService;
import com.els.modules.material.api.service.MainDataTodoListRpcService;
import com.els.modules.order.api.service.OrderTodoListRpcService;
import com.els.modules.sample.api.service.OtherTodoListRpcService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.todo.enums.TodoTypeEnum;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TodoListServiceImpl
implements TodoListService {
    private static final Logger log = LoggerFactory.getLogger(TodoListServiceImpl.class);
    @Resource
    private AccountRpcService accountRpcService;
    @Lazy
    @Resource
    private SupplierTodoListRpcService supplierTodoListRpcService;
    @Lazy
    @Resource
    private MainDataTodoListRpcService mainDataTodoListRpcService;
    @Lazy
    @Resource
    private OrderTodoListRpcService orderTodoListRpcService;
    @Lazy
    @Resource
    private FinanceTodoListRpcService financeTodoListRpcService;
    @Lazy
    @Resource
    private ContractTodoListRpcService contractTodoListRpcService;
    @Lazy
    @Resource
    private OtherTodoListRpcService otherTodoListRpcService;

    public List<TodoCountInfoVO> getTodoCountList() {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List permissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList<PermissionDTO>();
        List allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        if (filterPermissionDTOList.size() == 0) {
            return null;
        }
        return this.processTodoCountInfo(filterPermissionDTOList, TenantContext.getTenant());
    }

    private List<TodoCountInfoVO> processTodoCountInfo(List<PermissionDTO> permissionDTOList, String elsAccount) {
        ArrayList<TodoCountInfoVO> todList = new ArrayList<TodoCountInfoVO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            ArrayList<String> statusList;
            TodoStatusVO statusVO;
            Integer count;
            ArrayList<String> standardStatusList;
            TodoCountInfoVO vo;
            Integer count2;
            ArrayList<String> standardStatusList2;
            TodoCountInfoVO vo2;
            Integer count1;
            ArrayList<String> standardStatusList1;
            if (TodoTypeEnum.PURCHASE_1.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList1 = new ArrayList<String>();
                standardStatusList1.add("1");
                count1 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u68c0\u67e5\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                if (count1 > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count1);
                    TodoStatusVO statusVO1 = new TodoStatusVO();
                    statusVO1.setName("standardStatus");
                    statusVO1.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO1));
                    vo2.setModuleName(vo2.getModuleName() + "(\u68c0\u67e5\u4e2d)");
                    todList.add(vo2);
                }
                standardStatusList2 = new ArrayList<String>();
                standardStatusList2.add("2");
                count2 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u8bc4\u4f30\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    TodoStatusVO statusVO2 = new TodoStatusVO();
                    statusVO2.setName("standardStatus");
                    statusVO2.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO2));
                    vo.setModuleName(vo.getModuleName() + "(\u8bc4\u4f30\u4e2d)");
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_2.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList<String>();
                standardStatusList.add("3");
                count = this.supplierTodoListRpcService.countSupplierInfoChangeHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("3");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_3.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.supplierTodoListRpcService.countSupplierAccessMgmtQuareviewHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("quareviewStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_4.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("4");
                count = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_5.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseOrderHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("orderStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_6.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseOrderDeliveryPlanList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_7.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeOrderList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_8.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_9.getUrl().equals(permissionDTO.getUrl())) {
                TodoStatusVO statusVO2;
                standardStatusList1 = new ArrayList();
                standardStatusList1.add("1");
                count1 = this.financeTodoListRpcService.countPurchaseOrderHeadSaleRecAffirmStatusList(elsAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                standardStatusList2 = new ArrayList();
                standardStatusList2.add("0");
                count2 = this.financeTodoListRpcService.countPurchaseOrderHeadPurchaseInvoiceAffirmStatusList(elsAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count1);
                    vo.setModuleName(vo.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4)");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("saleRecAffirmStatus");
                    statusVO2.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO2));
                    todList.add(vo);
                }
                if (count2 > 0) {
                    vo = this.processTodoInfo(permissionDTO, count2);
                    vo.setModuleName(vo.getModuleName() + "(\u5f85\u786e\u8ba4)");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("purchaseInvoiceAffirmStatus");
                    statusVO2.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO2));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList<String>();
                statusList.add("1");
                count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_11.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("contractStatus");
                    statusVO.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadHisList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("contractStatus");
                    statusVO.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("rectificationStatus");
                    statusVO.setValue("4");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_14.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseSampleHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("sampleStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_15.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseMassProdHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_16.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_17.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("0");
                count = this.otherTodoListRpcService.countPurchaseSpcnList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_17.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("purchaseConfirmStatus");
                    statusVO.setValue("0");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_18.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldMaintainList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_18.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("maintainStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_19.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldScrappedList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("scrappedStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_20.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchasePerformanceDetailReportList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("appealStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_21.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countPurchasePerformanceReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("reportStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_22.getUrl().equals(permissionDTO.getUrl())) {
                Integer count3 = ((PurchaseSafetyStockTodoListExtendRpcService)SpringContextUtils.getBean(PurchaseSafetyStockTodoListExtendRpcService.class)).countSafetyStockList(elsAccount, "1");
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_22.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
                if (count3 > 0) {
                    TodoCountInfoVO vo3 = this.processTodoInfo(permissionDTO, count3);
                    TodoStatusVO statusVO3 = new TodoStatusVO();
                    statusVO3.setName("lessThanSetQuantity");
                    statusVO3.setValue("1");
                    vo3.setStatusList(Arrays.asList(statusVO3));
                    vo3.setModuleName("\u5b89\u5168\u5e93\u5b58\u9884\u8b66\u6570\u91cf");
                    todList.add(vo3);
                }
            }
            if (TodoTypeEnum.SUPPLIER_1.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("quareviewStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_2.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleStandardHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("standardStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_3.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.mainDataTodoListRpcService.countSaleInformationRecordsRequestHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("2");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_4.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleOrderHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("orderStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_5.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_6.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_7.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleRefundsDeliveryHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("refundsDeliveryStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_8.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleReconciliationList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("reconciliationStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_9.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleDeductCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("rectificationStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_11.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleSampleHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("sampleStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleMassProdHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.SUPPLIER_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleInspectionHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("1");
                    vo2.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo2);
                }
            }
            if (!TodoTypeEnum.SUPPLIER_14.getUrl().equals(permissionDTO.getUrl())) continue;
            statusList = new ArrayList();
            statusList.add("1");
            count = this.otherTodoListRpcService.countSaleMouldTransferHeadList(elsAccount, statusList);
            log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
            if (count <= 0) continue;
            vo2 = this.processTodoInfo(permissionDTO, count);
            statusVO = new TodoStatusVO();
            statusVO.setName("transferStatus");
            statusVO.setValue("1");
            vo2.setStatusList(Arrays.asList(statusVO));
            todList.add(vo2);
        }
        return todList;
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        vo.setModuleName(permissionDTO.getName());
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }
}

