/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.rpc.service;

import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.extend.api.finance.FinanceTodoListRpc2Service;
import com.els.modules.extend.api.permission.PermissionRpcService;
import com.els.modules.material.api.service.MainDataTodoListRpcService;
import com.els.modules.order.api.service.OrderTodoListRpcService;
import com.els.modules.sample.api.service.OtherTodoListRpcService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.todo.enums.TodoTypeEnum;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TodoListSingleServiceImpl
implements TodoListService {
    private static final Logger log = LoggerFactory.getLogger(TodoListSingleServiceImpl.class);
    @Resource
    @Lazy
    private SupplierTodoListRpcService supplierTodoListRpcService;
    @Resource
    @Lazy
    private MainDataTodoListRpcService mainDataTodoListRpcService;
    @Resource
    @Lazy
    private OrderTodoListRpcService orderTodoListRpcService;
    @Resource
    @Lazy
    private FinanceTodoListRpcService financeTodoListRpcService;
    @Resource
    @Lazy
    private ContractTodoListRpcService contractTodoListRpcService;
    @Resource
    @Lazy
    private OtherTodoListRpcService otherTodoListRpcService;
    @Resource
    @Lazy
    private FinanceTodoListRpc2Service financeTodoListRpc2Service;
    @Autowired
    private PermissionRpcService permissionRpcService;

    public List<TodoCountInfoVO> getTodoCountList() {
        List permission2DTOList;
        String adminFlag = AdminFlagUtil.getAdminFlag();
        String purchaseAccount = SysUtil.getPurchaseAccount();
        if ("1".equals(adminFlag)) {
            permission2DTOList = this.permissionRpcService.getLocalCompanyMenuList(purchaseAccount);
            permission2DTOList = TenantContext.getTenant().equals(purchaseAccount) ? permission2DTOList.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList()) : permission2DTOList.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
        } else {
            permission2DTOList = this.permissionRpcService.queryLocalByAccount(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        }
        ArrayList permissionDTOList = SysUtil.copyProperties((List)permission2DTOList, PermissionDTO.class);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList<PermissionDTO>();
        List allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return null;
        }
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-start");
        ArrayList<TodoCountInfoVO> resultTodoList = new ArrayList();
        resultTodoList = this.processTodoCountInfo(filterPermissionDTOList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-end");
        return resultTodoList;
    }

    private List<TodoCountInfoVO> processTodoCountInfo(List<PermissionDTO> permissionDTOList, String elsAccount, String subAccount) {
        ArrayList<TodoCountInfoVO> todList = new ArrayList<TodoCountInfoVO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            ArrayList<String> statusList;
            TodoStatusVO statusVO;
            TodoCountInfoVO vo;
            Integer count;
            ArrayList<String> standardStatusList;
            if (TodoTypeEnum.PURCHASE_2.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList<String>();
                standardStatusList.add("3");
                count = this.supplierTodoListRpcService.countSupplierInfoChangeHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("3");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_3.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.supplierTodoListRpcService.countSupplierAccessMgmtQuareviewHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("quareviewStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_4.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("4");
                count = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("4");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_5.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseOrderHeadList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("orderStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_5_1.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("4");
                count = this.orderTodoListRpcService.countPurchaseOrderItemList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("itemStatus");
                    statusVO.setValue("4");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_7.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeOrderList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_8.getUrl().equals(permissionDTO.getUrl())) {
                standardStatusList = new ArrayList();
                standardStatusList.add("2");
                count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeList(elsAccount, standardStatusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_9.getUrl().equals(permissionDTO.getUrl())) {
                TodoStatusVO statusVO2;
                TodoStatusVO statusVO3;
                TodoCountInfoVO vo2;
                ArrayList<String> standardStatusList1 = new ArrayList<String>();
                standardStatusList1.add("1");
                Integer count1 = this.financeTodoListRpc2Service.countPurchaseOrderHeadSaleRecAffirmStatusListNew(elsAccount, subAccount, standardStatusList1);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
                ArrayList<String> standardStatusList2 = new ArrayList<String>();
                standardStatusList2.add("0");
                Integer count2 = this.financeTodoListRpc2Service.countPurchaseOrderHeadPurchaseInvoiceAffirmStatusListNew(elsAccount, subAccount, standardStatusList2);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
                if (count1 > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count1);
                    vo2.setModuleName(vo2.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("saleRecAffirmStatus");
                    statusVO3.setValue("1");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo2.setStatusList(Arrays.asList(statusVO3, statusVO2));
                    todList.add(vo2);
                }
                if (count2 > 0) {
                    vo2 = this.processTodoInfo(permissionDTO, count2);
                    vo2.setModuleName(vo2.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
                    statusVO3 = new TodoStatusVO();
                    statusVO3.setName("purchaseInvoiceAffirmStatus");
                    statusVO3.setValue("0");
                    statusVO2 = new TodoStatusVO();
                    statusVO2.setName("cancellation");
                    statusVO2.setValue("0");
                    vo2.setStatusList(Arrays.asList(statusVO3, statusVO2));
                    todList.add(vo2);
                }
            }
            if (TodoTypeEnum.PURCHASE_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList<String>();
                statusList.add("1");
                count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_10_1.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("3");
                count = this.financeTodoListRpcService.countPurchaseDeductCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("3");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_11.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("contractStatus");
                    statusVO.setValue("4");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.contractTodoListRpcService.countPurchaseContractHeadHisList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("contractStatus");
                    statusVO.setValue("4");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("4");
                count = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("rectificationStatus");
                    statusVO.setValue("4");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_16.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_17.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("0");
                count = this.otherTodoListRpcService.countPurchaseSpcnList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_17.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("purchaseConfirmStatus");
                    statusVO.setValue("0");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_18.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldMaintainList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_18.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("maintainStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_19.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchaseMouldScrappedList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("scrappedStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_20.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countPurchasePerformanceDetailReportList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("appealStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.PURCHASE_21.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countPurchasePerformanceReportHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("reportStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_1.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("quareviewStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_2.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.supplierTodoListRpcService.countSaleStandardHeadList(elsAccount, subAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("standardStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_3.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.mainDataTodoListRpcService.countSaleInformationRecordsRequestHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("status");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_4.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleOrderHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("orderStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_5.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_6.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("noticeStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_7.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.orderTodoListRpcService.countSaleRefundsDeliveryHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("refundsDeliveryStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_8.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleReconciliationList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("reconciliationStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_9.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.financeTodoListRpcService.countSaleDeductCostList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("confirmStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_10.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleSupplierRectificationReportHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("rectificationStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_12.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleMassProdHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_13.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleInspectionHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("documentsStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_14.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("1");
                count = this.otherTodoListRpcService.countSaleMouldTransferHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("transferStatus");
                    statusVO.setValue("1");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (TodoTypeEnum.SUPPLIER_15.getUrl().equals(permissionDTO.getUrl())) {
                statusList = new ArrayList();
                statusList.add("2");
                count = this.contractTodoListRpcService.countSaleContractHeadList(elsAccount, statusList);
                log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
                if (count > 0) {
                    vo = this.processTodoInfo(permissionDTO, count);
                    statusVO = new TodoStatusVO();
                    statusVO.setName("contractStatus");
                    statusVO.setValue("2");
                    vo.setStatusList(Arrays.asList(statusVO));
                    todList.add(vo);
                }
            }
            if (!TodoTypeEnum.SUPPLIER_16.getUrl().equals(permissionDTO.getUrl())) continue;
            statusList = new ArrayList();
            statusList.add("1");
            count = this.contractTodoListRpcService.countSaleContractPromiseList(elsAccount, statusList);
            log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
            if (count <= 0) continue;
            vo = this.processTodoInfo(permissionDTO, count);
            statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        return todList;
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        vo.setModuleName(I18nUtil.translate((String)permissionDTO.getNameI18nKey(), (String)permissionDTO.getName()));
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }
}

