/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.xc;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.jdyxc.enums.DictCodeEnum;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import com.els.modules.third.jdyxc.util.BeanConvertorUtil;
import com.els.modules.third.jdyxc.util.XcUtil;
import com.els.modules.third.xc.vo.BaseUnitVO;
import com.els.modules.third.xc.vo.CheckExistDto;
import com.els.modules.third.xc.vo.DictDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetBaseUnitFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetBaseUnitFromXcDbImpl.class);
    private static final String UNIT_LIST = "/jdy/v2/bd/measure_unit";
    @Autowired
    private DictService dictService;
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private DictItemMapper dictItemMapper;

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, UNIT_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject result = (JSONObject)custom;
        String elsAccount = result.getString("bus_account");
        String tenant = TenantContext.getTenant();
        TenantContext.setTenant((String)elsAccount);
        log.info(JSON.toJSONString((Object)obj));
        JSONObject jsonResult = XcUtil.getResult((JSONObject)obj, (String)elsAccount);
        List deptVOs = JSON.parseArray((String)jsonResult.getString("rows"), BaseUnitVO.class);
        ArrayList<DictDto> dicts = new ArrayList<DictDto>();
        for (BaseUnitVO settleTypeVO : deptVOs) {
            DictDto dictDto = new DictDto();
            BeanConvertorUtil.convertor((Object)settleTypeVO, (Object)dictDto);
            dicts.add(dictDto);
        }
        this.handleDict(DictCodeEnum.UNIT_CODE, ThirdTypeEnum.THIRD_JD_XC.getValue(), elsAccount, dicts);
        TenantContext.clear();
        TenantContext.setTenant((String)tenant);
        this.getPageInfo(obj, custom);
        return jsonResult;
    }

    public void handleDict(DictCodeEnum codeEnum, String thirdType, String elsAccount, List<DictDto> dictDtos) {
        Dict dict = (Dict)this.dictMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)codeEnum.getCode())).eq(BaseEntity::getDeleted, (Object)0)).eq(BaseEntity::getElsAccount, (Object)elsAccount));
        if (null == dict) {
            dict = new Dict();
            dict.setElsAccount(elsAccount);
            dict.setDeleted(Integer.valueOf(0));
            dict.setDictCode(codeEnum.getCode());
            dict.setDictName(codeEnum.getValue());
            dict.setDescription(codeEnum.getValue());
            dict.setCreateBy(elsAccount);
            dict.setCreateTime(new Date());
            dict.setElsAccount(elsAccount);
            this.dictService.save((Object)dict);
        }
        CheckExistDto checkExist = new CheckExistDto(dict.getId(), elsAccount, dictDtos, this.dictItemMapper).invoke();
        Set<String> updateIds = checkExist.getUpdateIds();
        Map<String, DictDto> updateMap = checkExist.getUpdateMap();
        log.info("GetBaseUnitFromXcDbImpl->handleDict code:{}, dict\u540c\u6b65\u6570\u91cf:{}", (Object)codeEnum.getValue(), (Object)updateIds.size());
        ArrayList<DictItem> dictItems = new ArrayList<DictItem>();
        for (String key : updateIds) {
            DictDto dto = updateMap.get(key);
            DictItem dictItem = new DictItem();
            dictItem.setThirdPartyId(dto.getId());
            dictItem.setThirdType(thirdType);
            dictItem.setItemValue(StrUtil.isNotBlank((CharSequence)dto.getNumber()) ? dto.getNumber() : dto.getId());
            dictItem.setCreateBy(elsAccount);
            dictItem.setCreateTime(new Date());
            dictItem.setElsAccount(elsAccount);
            dictItem.setDictId(dict.getId());
            dictItem.setItemText(dto.getName());
            dictItem.setStatus(Integer.valueOf(1));
            dictItem.setDescription(dto.getName());
            dictItem.setSortOrder(Integer.valueOf(3));
            dictItems.add(dictItem);
        }
        if (!CollectionUtils.isEmpty(dictItems)) {
            this.dictItemService.saveBatch(dictItems, 200);
        }
    }
}

