/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.third.sql.dto.DictDto;
import com.els.modules.third.sql.util.OracleSqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetAssistanFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetAssistanFromCQGTOracleDbImpl.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private DictItemMapper dictItemMapper;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_ITEM_UOM";
        obj.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetAssistanFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        List dictDto = JSONArray.parseArray((String)OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult).toJSONString(), DictDto.class);
        Map<String, List<DictDto>> listMap = dictDto.stream().collect(Collectors.groupingBy(dict -> dict.getGroupKey() + "_" + dict.getGroupName()));
        String elsAccount = TenantContext.getTenant();
        ArrayList<DictItem> insertAccount = new ArrayList<DictItem>();
        ArrayList updateAccount = new ArrayList();
        for (Map.Entry<String, List<DictDto>> entry : listMap.entrySet()) {
            String key = entry.getKey();
            List<DictDto> dictDtos = entry.getValue();
            String[] s = key.split("_");
            String groupKey = s[0];
            String groupName = s[1];
            Dict dict2 = this.getDict(groupKey, groupName, elsAccount);
            Map<String, DictItem> dictItemMap = this.getDictItem(dict2.getId(), elsAccount);
            for (DictDto dto : dictDtos) {
                if (dictItemMap.containsKey(dto.getUomCode())) continue;
                DictItem dictItem = new DictItem();
                dictItem.setDictId(dict2.getId());
                dictItem.setItemValue(dto.getUomCode());
                dictItem.setItemText(dto.getUom());
                dictItem.setDescription(dto.getUom());
                dictItem.setStatus(Integer.valueOf("\u6b63\u5e38".equals(dto.getStatus()) ? 1 : 0));
                dictItem.setUpdateTime(OracleSqlUtil.getUpdateTime((String)dto.getUpdateTime()));
                dictItem.setCreateBy(elsAccount);
                dictItem.setCreateTime(new Date());
                dictItem.setElsAccount(elsAccount);
                insertAccount.add(dictItem);
            }
        }
        if (CollectionUtil.isNotEmpty(insertAccount)) {
            this.dictItemService.saveBatch(insertAccount, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateAccount)) {
            this.dictItemService.updateBatchById(updateAccount, 2000);
        }
        return interfaceResult;
    }

    private Dict getDict(String dictCode, String dictValue, String elsAccount) {
        Dict dict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)dictCode)).eq(BaseEntity::getDeleted, (Object)0)).eq(BaseEntity::getElsAccount, (Object)elsAccount));
        if (null == dict) {
            dict = new Dict();
            dict.setElsAccount(elsAccount);
            dict.setDeleted(Integer.valueOf(0));
            dict.setDictCode(dictCode);
            dict.setDictName(dictValue);
            dict.setDescription(dictValue);
            dict.setCreateBy(elsAccount);
            dict.setCreateTime(new Date());
            dict.setElsAccount(elsAccount);
            this.dictService.save((Object)dict);
        }
        return dict;
    }

    private Map<String, DictItem> getDictItem(String dictMainId, String elsAccount) {
        List dictIdByMainId = this.dictItemMapper.findDictIdByMainId(dictMainId, elsAccount);
        if (CollectionUtils.isEmpty((Collection)dictIdByMainId)) {
            return new HashMap<String, DictItem>();
        }
        return dictIdByMainId.stream().collect(Collectors.toMap(DictItem::getItemValue, Function.identity(), (newVal, oldVal) -> oldVal));
    }
}

