/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.todo.rpc.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.api.service.ContractTodoListRpcService;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.api.service.InquiryTodoListRpcService;
import com.els.modules.history.entity.ElsBusinessTransferHis;
import com.els.modules.material.api.service.MainDataTodoListRpcService;
import com.els.modules.order.api.service.OrderTodoListRpcService;
import com.els.modules.sample.api.dto.TodoCountInfoDTO;
import com.els.modules.sample.api.service.ExtendTodoListRpcService;
import com.els.modules.sample.api.service.OtherTodoListRpcService;
import com.els.modules.supplier.api.service.SupplierTodoListRpcService;
import com.els.modules.todo.enums.TodoTypeEnum;
import com.els.modules.todo.service.rpc.service.TodoListService;
import com.els.modules.todo.utils.PageUtils;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TodoListSingleServiceImpl
implements TodoListService {
    private static final Logger log = LoggerFactory.getLogger(TodoListSingleServiceImpl.class);
    @Resource
    @Lazy
    private AccountRpcService accountRpcService;
    @Resource
    @Lazy
    private SupplierTodoListRpcService supplierTodoListRpcService;
    @Resource
    @Lazy
    private MainDataTodoListRpcService mainDataTodoListRpcService;
    @Resource
    @Lazy
    private OrderTodoListRpcService orderTodoListRpcService;
    @Resource
    @Lazy
    private FinanceTodoListRpcService financeTodoListRpcService;
    @Resource
    @Lazy
    private ContractTodoListRpcService contractTodoListRpcService;
    @Resource
    @Lazy
    private OtherTodoListRpcService otherTodoListRpcService;
    @Resource
    @Lazy
    private InquiryTodoListRpcService inquiryTodoListRpcService;
    @Resource
    @Lazy
    private ExtendTodoListRpcService extendTodoListRpcService;
    @Autowired
    @Lazy
    private PermissionDataQueryUtil permissionDataQueryUtil;
    @Resource
    @Lazy
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<TodoCountInfoVO> getTodoCountList() {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List allPermissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (allPermissionDTOList == null || allPermissionDTOList.size() == 0) {
            return null;
        }
        ArrayList filterPermissionDTOList = this.processPermissionTodoList(allPermissionDTOList);
        if (CollUtil.isEmpty(filterPermissionDTOList)) {
            filterPermissionDTOList = Lists.newArrayList();
        }
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-start");
        ArrayList<TodoCountInfoVO> resultTodoList = new ArrayList();
        resultTodoList = this.processTodoCountInfo(allPermissionDTOList, filterPermissionDTOList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        log.info("<-----------------------\u5f85\u529e\u4e8b\u9879-end");
        return resultTodoList;
    }

    public IPage<ElsBusinessTransferHis> pageTodoCountList(Integer pageNo, Integer pageSize) {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List allPermissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (allPermissionDTOList == null || allPermissionDTOList.size() == 0) {
            return new Page();
        }
        List pageTodoList = PageUtils.startPage((List)allPermissionDTOList, (Integer)pageNo, (Integer)pageSize);
        List<TodoCountInfoVO> resultTodoList = this.processTodoCountInfo(allPermissionDTOList, pageTodoList, TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount());
        Page pageResult = new Page();
        pageResult.setRecords(resultTodoList);
        pageResult.setTotal((long)resultTodoList.size());
        pageResult.setSize((long)pageSize.intValue());
        pageResult.setPages((long)pageNo.intValue());
        return pageResult;
    }

    private List<PermissionDTO> processPermissionTodoList(List<PermissionDTO> allPermissionDTOList) {
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList();
        List allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : allPermissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        filterPermissionDTOList = filterPermissionDTOList.parallelStream().sorted(Comparator.comparing(PermissionDTO::getUrl)).collect(Collectors.toList());
        return filterPermissionDTOList;
    }

    private List<TodoCountInfoVO> processTodoCountInfo(List<PermissionDTO> allPermissionDTOList, List<PermissionDTO> permissionDTOList, String elsAccount, String subAccount) {
        ArrayList<TodoCountInfoVO> todList = new ArrayList<TodoCountInfoVO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            this.processPurchaseTodoList(elsAccount, subAccount, todList, permissionDTO);
            this.processSupplierTodoList(elsAccount, subAccount, todList, permissionDTO);
        }
        List extendTodoCountList = this.extendTodoListRpcService.getExtendTodoCountList(allPermissionDTOList, elsAccount, subAccount);
        if (extendTodoCountList != null && extendTodoCountList.size() > 0) {
            for (TodoCountInfoDTO dto : extendTodoCountList) {
                TodoCountInfoVO vo = new TodoCountInfoVO();
                BeanUtils.copyProperties((Object)dto, (Object)vo);
                List statusList = JSON.parseArray((String)JSON.toJSONString((Object)dto.getStatusList()), TodoStatusVO.class);
                vo.setStatusList(statusList);
                todList.add(vo);
            }
        }
        return todList;
    }

    private void processPurchaseTodoList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        if (TodoTypeEnum.PURCHASE_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseStandardHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSupplierInfoChangeHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_3.getUrl().equals(permissionDTO.getUrl())) {
            this.countSupplierAccessMgmtQuareviewHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_4.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseInformationRecordsRequestHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_5_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseOrderItemList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_7.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeliveryNoticeOrderList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_8.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeliveryNoticeList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_9.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseOrderHeadSaleRecList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_9_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceReconciliationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_9_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseReconciliationConfirmationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_10.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseAddCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_10_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeductCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_11.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseContractHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_12.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseContractHeadHisList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_12_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseContractPromiseList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_13.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSupplierRectificationReportHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_14.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSampleHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_14_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseQualityCheckHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_14_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSampleCheckHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_14_3.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseTrialProductionHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_15.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMassProdHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_16.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseInspectionHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_17.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseSpcnList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_18.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMouldMaintainList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_19.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMouldScrappedList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_20.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceDetailReportList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_21.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchasePerformanceReportHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_22.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseEnquiryList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_23.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseEbiddingList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_28.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseTenderProjectSubpackageList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_30.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseBiddingProjectSubpackageList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_24.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseBiddingHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_25.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseeValuationOfBidList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_26.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseQualificationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_29.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseMentoringHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_31.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseVisitHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_32.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseBookDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_33.getUrl().equals(permissionDTO.getUrl()) || TodoTypeEnum.PURCHASE_34.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_35.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseRefundsDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_36.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseRebateRuleList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.PURCHASE_37.getUrl().equals(permissionDTO.getUrl())) {
            this.countPurchaseRebateCalculationSheetList(elsAccount, todList, permissionDTO);
        }
    }

    private void countPurchaseRebateCalculationSheetList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseRebateRule");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count = this.financeTodoListRpcService.countPurchaseRebateCalculationSheetList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_37.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IFK_16d1fbd", (String)"\u5df2\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rebateStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.financeTodoListRpcService.countPurchaseRebateCalculationSheetList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_37.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_confirmed", (String)"\u5df2\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rebateStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseRebateRuleList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseRebateRule");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count = this.financeTodoListRpcService.countPurchaseRebateRuleList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_36.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IFK_16d1fbd", (String)"\u5df2\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ruleStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseTrialProductionHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("trialProduction");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.otherTodoListRpcService.countPurchaseTrialProductionHeadList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_GLucF4bjcFUiMJeD", (String)"\u5f85\u8bd5\u5236") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("trialStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count2 = this.otherTodoListRpcService.countPurchaseTrialProductionHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_YTJqHb11N8JvzWGN", (String)"\u8bd5\u5236\u5b8c\u6210") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("trialStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSampleCheckHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("sampleCheck");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.otherTodoListRpcService.countPurchaseSampleCheckHeadList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_checking", (String)"\u68c0\u6d4b\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("checkStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseQualityCheckHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("qualityCheck");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.otherTodoListRpcService.countPurchaseQualityCheckHeadList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_checking", (String)"\u68c0\u6d4b\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("checkStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseContractPromiseList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("contractPromise");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.contractTodoListRpcService.countPurchaseContractPromiseList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.contractTodoListRpcService.countPurchaseContractPromiseList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IYM_1727050", (String)"\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseRefundsDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("delivery");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.orderTodoListRpcService.countPurchaseRefundsDeliveryHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_35.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_confirmed", (String)"\u5df2\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("refundsDeliveryStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count2 = this.orderTodoListRpcService.countPurchaseRefundsDeliveryHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_35.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IYM_1727050", (String)"\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("refundsDeliveryStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"5"});
        Integer count3 = this.orderTodoListRpcService.countPurchaseRefundsDeliveryHeadList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_35.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_xzYS_4324cbc5", (String)"\u90e8\u5206\u9000\u8d27") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("refundsDeliveryStatus");
            statusVO.setValue("5");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("delivery");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.orderTodoListRpcService.countPurchaseDeliveryHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_33.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_hSKP_2836cbe2", (String)"\u53d1\u8d27\u5728\u9014") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("deliveryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        if (TodoTypeEnum.PURCHASE_33.getUrl().equals(permissionDTO.getUrl())) {
            return;
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.orderTodoListRpcService.countPurchaseDeliveryHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_33.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IuS_16b2a69", (String)"\u5df2\u5230\u8d27") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("deliveryStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count3 = this.orderTodoListRpcService.countPurchaseDeliveryHeadList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_33.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_xzlS_431f9d4f", (String)"\u90e8\u5206\u6536\u8d27") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("deliveryStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseBookDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bookDelivery");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.orderTodoListRpcService.countPurchaseBookDeliveryHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_32.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseVisitHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bookVisit");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.supplierTodoListRpcService.countPurchaseVisitHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_31.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count2 = this.supplierTodoListRpcService.countPurchaseVisitHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_31.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_omC_17316a8", (String)"\u5f85\u62dc\u8bbf") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count3 = this.supplierTodoListRpcService.countPurchaseVisitHeadList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_31.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oUu_177cdf8", (String)"\u5f85\u8bc4\u4ef7") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseBiddingProjectSubpackageList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("tender");
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("1");
        standardStatusList.add("3");
        standardStatusList.add("4");
        List tabStatusList = this.inquiryTodoListRpcService.countPurchaseBiddingProjectSubpackageList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_30.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)JSON.toJSONString((Object)tabStatusList));
        for (CountVO countVO : tabStatusList) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, countVO.getTotal());
            vo.setModuleName(vo.getModuleName() + "(" + countVO.getTitle() + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName(countVO.getFileName());
            statusVO.setValue(countVO.getValue());
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMentoringHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countPurchaseMentoringHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_29.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("viewStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseTenderProjectSubpackageList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("tender");
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        standardStatusList.add("3");
        standardStatusList.add("4");
        standardStatusList.add("5");
        List tabStatusList = this.inquiryTodoListRpcService.countPurchaseTenderProjectSubpackageList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)JSON.toJSONString((Object)tabStatusList));
        for (CountVO countVO : tabStatusList) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, countVO.getTotal());
            vo.setModuleName(vo.getModuleName() + "(" + countVO.getTitle() + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName(countVO.getFileName());
            statusVO.setValue(countVO.getValue());
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseStandardHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchase_standard");
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u68c0\u67e5\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            TodoStatusVO statusVO1 = new TodoStatusVO();
            statusVO1.setName("standardStatus");
            statusVO1.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO1));
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_0vq37GDwIYph08SX", (String)"\u68c0\u67e5\u4e2d") + ")");
            todList.add(vo);
        }
        this.getAccountBusinessType("purchase_standard");
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("2");
        Integer count2 = this.supplierTodoListRpcService.countPurchaseStandardHeadList(elsAccount, subAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_1.getModuleName() + "(\u8bc4\u4f30\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("standardStatus");
            statusVO2.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO2));
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_column_zqx3q0dOMWsxx94E", (String)"\u8bc4\u4f30\u4e2d") + ")");
            todList.add(vo);
        }
    }

    private void countSupplierInfoChangeHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("SupplierInfoChange");
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("3");
        Integer count = this.supplierTodoListRpcService.countSupplierInfoChangeHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("accessMgmtQuareview");
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.supplierTodoListRpcService.countSupplierAccessMgmtQuareviewHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("quareviewStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseInformationRecordsRequestHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("4");
        Integer count = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_obLumtH_52df74a0", (String)"\u5f85\u751f\u6210\u4ef7\u683c\u8bb0\u5f55") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("3");
        Integer count2 = this.mainDataTodoListRpcService.countPurchaseInformationRecordsRequestHeadList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IFK_16d1fbd", (String)"\u5df2\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseOrderItemList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("4");
        Integer count = this.orderTodoListRpcService.countPurchaseOrderItemList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_5_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("itemStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeliveryNoticeOrderList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeOrderList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeliveryNoticeList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.orderTodoListRpcService.countPurchaseDeliveryNoticeList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_8.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseOrderHeadSaleRecList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("reconciliation");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count1 = this.financeTodoListRpcService.countPurchaseReconciliationStatusList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        this.getAccountBusinessType("reconciliation");
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("2");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"8"});
        Integer count2 = this.financeTodoListRpcService.countPurchaseReconciliationStatusList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u53d1\u7968\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_hPoRL_d5c5e424", (String)"\u53d1\u7968\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("8");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"5"});
        Integer count3 = this.financeTodoListRpcService.countPurchaseReconciliationStatusList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u4f9b\u5e94\u5546\u62d2\u7edd),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_RdXFK_8e13c518", (String)"\u4f9b\u5e94\u5546\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("5");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList4 = Lists.newArrayList((Object[])new String[]{"6"});
        Integer count4 = this.financeTodoListRpcService.countPurchaseReconciliationStatusList(elsAccount, (List)standardStatusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9.getModuleName() + "(\u5f85\u5f00\u7968),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_ovP_1728cad", (String)"\u5f85\u5f00\u7968") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("6");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceReconciliationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count1 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u91c7\u8d2d\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeConfirmedPurchase", (String)"\u5f85\u91c7\u8d2d\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("2");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"8"});
        Integer count2 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u53d1\u7968\u5f85\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_hPoRL_d5c5e424", (String)"\u53d1\u7968\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("8");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"5"});
        Integer count3 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u4f9b\u5e94\u5546\u62d2\u7edd),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_RdXFK_8e13c518", (String)"\u4f9b\u5e94\u5546\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("5");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
        ArrayList standardStatusList4 = Lists.newArrayList((Object[])new String[]{"6"});
        Integer count4 = this.financeTodoListRpcService.countPurchasePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_1.getModuleName() + "(\u5f85\u5f00\u7968),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_ovP_1728cad", (String)"\u5f85\u5f00\u7968") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("6");
            TodoStatusVO statusVO2 = new TodoStatusVO();
            statusVO2.setName("cancellation");
            statusVO2.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO, statusVO2));
            todList.add(vo);
        }
    }

    private void countPurchaseReconciliationConfirmationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseReconciliationConfirmation");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.financeTodoListRpcService.countPurchaseReconciliationConfirmationList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oICRL_6d6706db", (String)"\u5f85\u5bf9\u65b9\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("preparedByStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count2 = this.financeTodoListRpcService.countPurchaseReconciliationConfirmationList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_9_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oACRL_7d5d329e", (String)"\u5f85\u7f16\u65b9\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("preparedByStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseAddCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("addCost");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseDeductCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("deductCost");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("3");
        Integer count = this.financeTodoListRpcService.countPurchaseDeductCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_10_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseContractHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("contract");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.contractTodoListRpcService.countPurchaseContractHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseContractHeadHisList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("contract");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.contractTodoListRpcService.countPurchaseContractHeadHisList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSupplierRectificationReportHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("supplierRetification");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("4");
        Integer count = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_UUs_2181170", (String)"\u8bc4\u5ba1\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList3 = new ArrayList<String>();
        statusList3.add("3");
        Integer count3 = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IYM_1727050", (String)"\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList4 = new ArrayList<String>();
        statusList4.add("5");
        Integer count4 = this.otherTodoListRpcService.countPurchaseSupplierRectificationReportHeadList(elsAccount, statusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_UUML_40ec1d21", (String)"\u8bc4\u5ba1\u5b8c\u6210") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("5");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSampleHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("sample");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseSampleHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("sampleStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMassProdHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("massProdHead");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseMassProdHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseInspectionHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("siteInspection");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oUz_177d107", (String)"\u5f85\u8bc4\u5206") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList2 = new ArrayList<String>();
        statusList2.add("3");
        Integer count2 = this.otherTodoListRpcService.countPurchaseInspectionHeadList(elsAccount, subAccount, statusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_xzUz_43240d60", (String)"\u90e8\u5206\u8bc4\u5206") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseSpcnList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.otherTodoListRpcService.countPurchaseSpcnList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_17.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("purchaseConfirmStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMouldMaintainList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseMouldMaintain");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchaseMouldMaintainList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_18.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("maintainStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseMouldScrappedList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseMouldMaintain");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchaseMouldScrappedList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("scrappedStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceDetailReportList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("performanceReportDeliveryRate");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countPurchasePerformanceDetailReportList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("appealStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchasePerformanceReportHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("performanceReport");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countPurchasePerformanceReportHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("reportStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseEnquiryList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("enquiry");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countPurchaseEnquiryList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_22.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseEbiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("ebidding");
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("3");
        Integer count2 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList3 = new ArrayList<String>();
        standardStatusList3.add("4");
        Integer count3 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u7ade\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_bidding", (String)"\u7ade\u4ef7\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList4 = new ArrayList<String>();
        standardStatusList4.add("5");
        Integer count4 = this.inquiryTodoListRpcService.countPurchaseEbiddingList(elsAccount, standardStatusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_23.getModuleName() + "(\u7ade\u4ef7\u7ed3\u675f),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_biddingOver", (String)"\u7ade\u4ef7\u7ed3\u675f") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("5");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseBiddingHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bidding");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_YBs_17fff21", (String)"\u62db\u6807\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList2 = new ArrayList<String>();
        statusList2.add("4");
        Integer count2 = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IBs_164c420", (String)"\u5b9a\u6807\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseeValuationOfBidList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bidding");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("3");
        Integer count = this.inquiryTodoListRpcService.countPurchaseBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_25.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countPurchaseQualificationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("purchaseQualificationReview");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countPurchaseQualificationList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_26.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("reviewStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void processSupplierTodoList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        if (TodoTypeEnum.SUPPLIER_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleStandardHeadList(elsAccount, subAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_3.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleInformationRecordsRequestHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_4.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleOrderHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_5.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeliveryNoticeByOrderList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_6.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeliveryNoticeList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_7.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleRefundsDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_8.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleReconciliationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_8_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countSalePerformanceReconciliationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_8_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleReconciliationConfirmationList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_9.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleDeductCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_9_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleAddCostList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_10.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSupplierRectificationReportHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_11.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSampleHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_11_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleTrialProductionHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_11_2.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleEcnList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_12.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleMassProdHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_13.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleInspectionHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_14.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleMouldTransferHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_15.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleContractHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_16.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleContractPromiseList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_17.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleEnquiryList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_18.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleEbiddingList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_19.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleBiddingList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_20.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleMentoringHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_21.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleClarificationInfoListList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_22.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleTenderProjectSubpackageList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_22_1.getUrl().equals(permissionDTO.getUrl())) {
            this.countTenderProjectSignUpList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_23.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleVisitHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_24.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleBookDeliveryHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_25.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleSupplierInfoChangeHeadList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_26.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleRebateRuleList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_27.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleRebateCalculationSheetList(elsAccount, todList, permissionDTO);
        }
        if (TodoTypeEnum.SUPPLIER_28.getUrl().equals(permissionDTO.getUrl())) {
            this.countSaleForecastSheetList(elsAccount, todList, permissionDTO);
        }
    }

    private void countSaleForecastSheetList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countSaleForecastSheetList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_28.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirm");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleRebateCalculationSheetList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.financeTodoListRpcService.countSaleRebateCalculationSheetList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_27.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rebateStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleRebateRuleList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.financeTodoListRpcService.countSaleRebateRuleList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_26.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ruleStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countTenderProjectSignUpList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("3");
        Integer count = this.inquiryTodoListRpcService.countTenderProjectSignUpList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_22_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleEcnList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("0");
        Integer count = this.otherTodoListRpcService.countSaleEcnList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("viewStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleTrialProductionHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        Integer count = this.otherTodoListRpcService.countSaleTrialProductionHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("trialStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSupplierInfoChangeHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("5");
        Integer count = this.supplierTodoListRpcService.countSaleSupplierInfoChangeHeadList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_25.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("5");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleBookDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bookDelivery");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.orderTodoListRpcService.countSaleBookDeliveryHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_24.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_confirmed", (String)"\u5df2\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.orderTodoListRpcService.countSaleBookDeliveryHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.PURCHASE_32.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_nRFK_4462b111", (String)"\u91c7\u8d2d\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleVisitHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("bookVisit");
        ArrayList standardStatusList = Lists.newArrayList((Object[])new String[]{"1"});
        Integer count = this.supplierTodoListRpcService.countSaleVisitHeadList(elsAccount, (List)standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_23.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count2 = this.supplierTodoListRpcService.countSaleVisitHeadList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_23.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_omC_17316a8", (String)"\u5f85\u62dc\u8bbf") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count3 = this.supplierTodoListRpcService.countSaleVisitHeadList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_23.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oUu_177cdf8", (String)"\u5f85\u8bc4\u4ef7") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("visitStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleReconciliationConfirmationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("saleReconciliationConfirmation");
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"2"});
        Integer count = this.financeTodoListRpcService.countSaleReconciliationConfirmationStatusList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oICRL_6d6706db", (String)"\u5f85\u5bf9\u65b9\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("preparedByStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count2 = this.financeTodoListRpcService.countSaleReconciliationConfirmationStatusList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_oICRL_6d6706db", (String)"\u5f85\u5bf9\u65b9\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("preparedByStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleTenderProjectSubpackageList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("tender");
        ArrayList<String> standardStatusList = new ArrayList<String>();
        standardStatusList.add("2");
        standardStatusList.add("3");
        standardStatusList.add("4");
        standardStatusList.add("5");
        List tabStatusList = this.inquiryTodoListRpcService.countSaleTenderProjectSubpackageList(elsAccount, standardStatusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_22.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)JSON.toJSONString((Object)tabStatusList));
        for (CountVO countVO : tabStatusList) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, countVO.getTotal());
            vo.setModuleName(vo.getModuleName() + "(" + countVO.getTitle() + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName(countVO.getFileName());
            statusVO.setValue(countVO.getValue());
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleClarificationInfoListList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("0");
        Integer count = this.inquiryTodoListRpcService.countSaleClarificationInfoListList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_21.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("viewStatus");
            statusVO.setValue("0");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleMentoringHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countSaleMentoringHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_20.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("submitStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSupplierAccessMgmtQuareviewHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countSaleSupplierAccessMgmtQuareviewHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("quareviewStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleStandardHeadList(String elsAccount, String subAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.supplierTodoListRpcService.countSaleStandardHeadList(elsAccount, subAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_2.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("standardStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleInformationRecordsRequestHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.mainDataTodoListRpcService.countSaleInformationRecordsRequestHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_3.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleOrderHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleOrderHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_4.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("orderStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeliveryNoticeByOrderList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_waitSupplierSure", (String)"\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList2 = new ArrayList<String>();
        statusList2.add("3");
        Integer count2 = this.orderTodoListRpcService.countSaleDeliveryNoticeByOrderList(elsAccount, statusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_5.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_confirmed", (String)"\u5df2\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeliveryNoticeList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_waitSupplierSure", (String)"\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList2 = new ArrayList<String>();
        statusList2.add("3");
        Integer count2 = this.orderTodoListRpcService.countSaleDeliveryNoticeList(elsAccount, statusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_6.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_confirmed", (String)"\u5df2\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("noticeStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleRefundsDeliveryHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.orderTodoListRpcService.countSaleRefundsDeliveryHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_7.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("refundsDeliveryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleReconciliationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count = this.financeTodoListRpcService.countSaleReconciliationStatusList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + "(\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_waitSupplierSure", (String)"\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.financeTodoListRpcService.countSaleReconciliationStatusList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + "(\u91c7\u8d2d\u62d2\u7edd),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_nRFK_4462b111", (String)"\u91c7\u8d2d\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"6"});
        Integer count3 = this.financeTodoListRpcService.countSaleReconciliationStatusList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + "(\u5f85\u5f00\u7968),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_ovP_1728cad", (String)"\u5f85\u5f00\u7968") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("6");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList4 = Lists.newArrayList((Object[])new String[]{"9"});
        Integer count4 = this.financeTodoListRpcService.countSaleReconciliationStatusList(elsAccount, (List)standardStatusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8.getModuleName() + "(\u53d1\u7968\u5df2\u9000\u56de),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_hPIYM_d5c2a139", (String)"\u53d1\u7968\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("9");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSalePerformanceReconciliationList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList standardStatusList1 = Lists.newArrayList((Object[])new String[]{"3"});
        Integer count = this.financeTodoListRpcService.countSalePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_waitSupplierSure", (String)"\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList2 = Lists.newArrayList((Object[])new String[]{"4"});
        Integer count2 = this.financeTodoListRpcService.countSalePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u91c7\u8d2d\u62d2\u7edd),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_nRFK_4462b111", (String)"\u91c7\u8d2d\u62d2\u7edd") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList3 = Lists.newArrayList((Object[])new String[]{"6"});
        Integer count3 = this.financeTodoListRpcService.countSalePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u5f85\u5f00\u7968),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_ovP_1728cad", (String)"\u5f85\u5f00\u7968") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("6");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList standardStatusList4 = Lists.newArrayList((Object[])new String[]{"9"});
        Integer count4 = this.financeTodoListRpcService.countSalePerformanceReconciliationStatusList(elsAccount, (List)standardStatusList4, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_8_1.getModuleName() + "(\u53d1\u7968\u5df2\u9000\u56de),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count4);
        if (count4 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count4);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_hPIYM_d5c2a139", (String)"\u53d1\u7968\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("status");
            statusVO.setValue("9");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleDeductCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countSaleDeductCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleAddCostList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("3");
        Integer count = this.financeTodoListRpcService.countSaleAddCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_9_1.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("confirmStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSupplierRectificationReportHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleSupplierRectificationReportHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_10.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_irs_1896888", (String)"\u6574\u6539\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("rectificationStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleSampleHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleSampleHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_11.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("sampleStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleMassProdHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleMassProdHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_12.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleInspectionHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleInspectionHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_13.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("documentsStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleMouldTransferHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.otherTodoListRpcService.countSaleMouldTransferHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_14.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("transferStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleContractHeadList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("2");
        Integer count = this.contractTodoListRpcService.countSaleContractHeadList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_15.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("contractStatus");
            statusVO.setValue("2");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleContractPromiseList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.contractTodoListRpcService.countSaleContractPromiseList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_oRL_175b33b", (String)"\u5f85\u786e\u8ba4") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> statusList2 = new ArrayList<String>();
        statusList2.add("4");
        Integer count2 = this.contractTodoListRpcService.countSaleContractPromiseList(elsAccount, statusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_16.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_field_IYM_1727050", (String)"\u5df2\u9000\u56de") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("promiseStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleEnquiryList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        TodoStatusVO statusVO;
        TodoCountInfoVO vo;
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u62a5\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("7");
        Integer count2 = this.inquiryTodoListRpcService.countSaleEnquiryList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_17.getModuleName() + "(\u8bae\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count1 > 0) {
            vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_InQuotation", (String)"\u62a5\u4ef7\u4e2d") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        if (count2 > 0) {
            vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_dict_Ius_2163644", (String)"\u8bae\u4ef7\u4e2d") + ")");
            statusVO = new TodoStatusVO();
            statusVO.setName("enquiryStatus");
            statusVO.setValue("7");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleEbiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> standardStatusList1 = new ArrayList<String>();
        standardStatusList1.add("1");
        Integer count1 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList1, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u5e94\u6807),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count1);
        if (count1 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count1);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_toBeBid", (String)"\u5f85\u5e94\u6807") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList2 = new ArrayList<String>();
        standardStatusList2.add("3");
        Integer count2 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList2, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u5f85\u7ade\u4ef7),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count2);
        if (count2 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count2);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_pedingBid", (String)"\u5f85\u7ade\u4ef7") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("3");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
        ArrayList<String> standardStatusList3 = new ArrayList<String>();
        standardStatusList3.add("4");
        Integer count3 = this.inquiryTodoListRpcService.countSaleEbiddingList(elsAccount, standardStatusList3, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_18.getModuleName() + "(\u7ade\u4ef7\u4e2d),\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count3);
        if (count3 > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count3);
            vo.setModuleName(vo.getModuleName() + "(" + I18nUtil.translate((String)"i18n_title_bidding", (String)"\u7ade\u4ef7\u4e2d") + ")");
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("ebiddingStatus");
            statusVO.setValue("4");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private void countSaleBiddingList(String elsAccount, List<TodoCountInfoVO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType(null);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.inquiryTodoListRpcService.countSaleBiddingList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoTypeEnum.SUPPLIER_19.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoVO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusVO statusVO = new TodoStatusVO();
            statusVO.setName("biddingStatus");
            statusVO.setValue("1");
            vo.setStatusList(Arrays.asList(statusVO));
            todList.add(vo);
        }
    }

    private String getAccountBusinessType(String businessType) {
        String accountBusinessType = null;
        if (StrUtil.isNotBlank((CharSequence)businessType)) {
            accountBusinessType = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount() + "-" + businessType;
        }
        return accountBusinessType;
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        vo.setModuleName(I18nUtil.translate((String)permissionDTO.getNameI18nKey(), (String)permissionDTO.getName()));
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }
}

