/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.imports.verifys;

import com.els.framework.poi.excel.entity.result.ExcelVerifyHanlderResult;
import java.util.regex.Pattern;

public class BaseVerifyHandler {
    private static String NOT_NULL = "\u4e0d\u5141\u8bb8\u4e3a\u7a7a";
    private static String IS_MOBILE = "\u4e0d\u662f\u624b\u673a\u53f7";
    private static String IS_TEL = "\u4e0d\u662f\u7535\u8bdd\u53f7\u7801";
    private static String IS_EMAIL = "\u4e0d\u662f\u90ae\u7bb1\u5730\u5740";
    private static String MIN_LENGHT = "\u5c0f\u4e8e\u89c4\u5b9a\u957f\u5ea6";
    private static String MAX_LENGHT = "\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6";
    private static Pattern mobilePattern = Pattern.compile("^[1][3,4,5,8,7][0-9]{9}$");
    private static Pattern telPattern = Pattern.compile("^([0][1-9]{2,3}-)?[0-9]{5,10}$");
    private static Pattern emailPattern = Pattern.compile("^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w{2,3}){1,3})$");

    public static ExcelVerifyHanlderResult isEmail(String name, Object val) {
        if (!emailPattern.matcher(String.valueOf(val)).matches()) {
            return new ExcelVerifyHanlderResult(false, name + IS_EMAIL);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult isMobile(String name, Object val) {
        if (!mobilePattern.matcher(String.valueOf(val)).matches()) {
            return new ExcelVerifyHanlderResult(false, name + IS_MOBILE);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult isTel(String name, Object val) {
        if (!telPattern.matcher(String.valueOf(val)).matches()) {
            return new ExcelVerifyHanlderResult(false, name + IS_TEL);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult maxLength(String name, Object val, int maxLength) {
        if (BaseVerifyHandler.notNull(name, val).isSuccess() && String.valueOf(val).length() > maxLength) {
            return new ExcelVerifyHanlderResult(false, name + MAX_LENGHT);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult minLength(String name, Object val, int minLength) {
        if (BaseVerifyHandler.notNull(name, val).isSuccess() && String.valueOf(val).length() < minLength) {
            return new ExcelVerifyHanlderResult(false, name + MIN_LENGHT);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult notNull(String name, Object val) {
        if (val == null || val.toString().equals("")) {
            return new ExcelVerifyHanlderResult(false, name + NOT_NULL);
        }
        return new ExcelVerifyHanlderResult(true);
    }

    public static ExcelVerifyHanlderResult regex(String name, Object val, String regex, String regexTip) {
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(String.valueOf(val)).matches()) {
            return new ExcelVerifyHanlderResult(false, name + regexTip);
        }
        return new ExcelVerifyHanlderResult(true);
    }
}

