/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dashboard.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.dashboard.entity.Dashboard;
import com.els.modules.dashboard.service.ChartUserConfigService;
import com.els.modules.dashboard.service.DashboardChartService;
import com.els.modules.dashboard.service.DashboardService;
import com.els.modules.dashboard.vo.ChartConfigVO;
import com.els.modules.dashboard.vo.DashboardChartVO;
import com.els.modules.dashboard.vo.DashboardVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/dashboard/dashboard"})
@Api(tags={"\u770b\u677f"})
public class DashboardController
extends BaseController<Dashboard, DashboardService> {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private DashboardChartService dashboardChartService;
    @Autowired
    private ChartUserConfigService chartUserConfigService;

    @ApiOperation(value="\u56fe\u8868\u4e2a\u4eba\u914d\u7f6e-\u83b7\u53d6\u4e2a\u4eba\u770b\u677f", notes="\u56fe\u8868\u4e2a\u4eba\u914d\u7f6e-\u83b7\u53d6\u4e2a\u4eba\u770b\u677f")
    @GetMapping(value={"/getDashboard/{dashboardCode}"})
    public Result<?> getDashboard(@PathVariable(value="dashboardCode") String dashboardCode) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<ChartConfigVO> configList = this.chartUserConfigService.getDashboardByUserId(dashboardCode, sysUser.getId());
        return Result.ok(configList);
    }

    @ApiOperation(value="\u56fe\u8868\u4e2a\u4eba\u914d\u7f6e-\u83b7\u53d6\u4e2a\u4eba\u770b\u677f\u914d\u7f6e", notes="\u56fe\u8868\u4e2a\u4eba\u914d\u7f6e-\u83b7\u53d6\u4e2a\u4eba\u770b\u677f\u914d\u7f6e")
    @GetMapping(value={"/getDashboardConfig/{dashboardCode}"})
    public Result<?> getDashboardConfig(@PathVariable(value="dashboardCode") String dashboardCode) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List<ChartConfigVO> configList = this.chartUserConfigService.getDashboardConfigByUserId(dashboardCode, sysUser.getId());
        return Result.ok(configList);
    }

    @ApiOperation(value="\u770b\u677f-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u770b\u677f-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(Dashboard dashboard, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)dashboard), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dashboardService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u770b\u677f-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u770b\u677f-\u6dfb\u52a0", notes="\u770b\u677f-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody DashboardVO dashboardPage) {
        Dashboard dashboard = new Dashboard();
        BeanUtils.copyProperties((Object)((Object)dashboardPage), (Object)((Object)dashboard));
        this.dashboardService.saveMain(dashboard, dashboardPage.getDashboardChartList());
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u770b\u677f-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u770b\u677f-\u7f16\u8f91", notes="\u770b\u677f-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody DashboardVO dashboardPage) {
        Dashboard dashboard = new Dashboard();
        BeanUtils.copyProperties((Object)((Object)dashboardPage), (Object)((Object)dashboard));
        this.dashboardService.updateMain(dashboard, dashboardPage.getDashboardChartList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u770b\u677f-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u770b\u677f-\u901a\u8fc7id\u5220\u9664", notes="\u770b\u677f-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.dashboardService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u770b\u677f-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u770b\u677f-\u6279\u91cf\u5220\u9664", notes="\u770b\u677f-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.dashboardService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u770b\u677f-\u901a\u8fc7id\u67e5\u8be2", notes="\u770b\u677f-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        Dashboard dashboard = (Dashboard)((Object)this.dashboardService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)dashboard));
    }

    @ApiOperation(value="\u770b\u677f-\u901a\u8fc7\u770b\u677fid\u67e5\u8be2\u770b\u677f\u56fe\u8868", notes="\u770b\u677f-\u901a\u8fc7\u770b\u677fid\u67e5\u8be2\u770b\u677f\u56fe\u8868")
    @GetMapping(value={"/queryDashboardChartByMainId"})
    public Result<?> queryDashboardChartListByMainId(@RequestParam(name="id", required=true) String id) {
        List<DashboardChartVO> dashboardChartList = this.dashboardChartService.selectByMainId(id);
        Page page = new Page();
        page.setRecords(dashboardChartList);
        return Result.ok((Object)page);
    }

    @AutoLog(value="\u770b\u677f-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, Dashboard dashboard) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)dashboard), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<DashboardVO> pageList = new ArrayList<DashboardVO>();
        List dashboardList = this.dashboardService.list((Wrapper)queryWrapper);
        for (Dashboard temp : dashboardList) {
            DashboardVO vo = new DashboardVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u770b\u677f");
        mv.addObject("entity", DashboardVO.class);
        mv.addObject("params", (Object)new ExportParams("\u770b\u677f\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u770b\u677f", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u770b\u677f-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<DashboardVO> list = ExcelImportUtil.importExcel(file.getInputStream(), DashboardVO.class, params);
                for (DashboardVO page : list) {
                    Dashboard po = new Dashboard();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.dashboardService.saveMain(po, page.getDashboardChartList());
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

