/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.system.entity.ElsQueryHead;
import com.els.modules.system.entity.ElsQueryItem;
import com.els.modules.system.service.ElsQueryHeadService;
import com.els.modules.system.service.ElsQueryItemService;
import com.els.modules.system.vo.ElsQueryHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/queryHead"})
@Api(tags={"\u9ad8\u7ea7\u67e5\u8be2\u5934"})
public class ElsQueryHeadController
extends BaseController<ElsQueryHead, ElsQueryHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsQueryHeadController.class);
    @Autowired
    private ElsQueryHeadService elsQueryHeadService;
    @Autowired
    private ElsQueryItemService elsQueryItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsQueryHead elsQueryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsQueryHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsQueryHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsQueryHeadVO elsQueryHeadPage) {
        ElsQueryHead elsQueryHead = new ElsQueryHead();
        BeanUtils.copyProperties((Object)((Object)elsQueryHeadPage), (Object)((Object)elsQueryHead));
        elsQueryHead.setSubAccount(this.getCurrentUser().getSubAccount());
        this.elsQueryHeadService.saveMain(elsQueryHead, elsQueryHeadPage.getElsQueryItemList());
        return Result.ok((Object)((Object)elsQueryHead));
    }

    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsQueryHeadVO elsQueryHeadPage) {
        ElsQueryHead elsQueryHead = new ElsQueryHead();
        BeanUtils.copyProperties((Object)((Object)elsQueryHeadPage), (Object)((Object)elsQueryHead));
        elsQueryHead.setSubAccount(this.getCurrentUser().getSubAccount());
        elsQueryHead.setElsAccount(TenantContext.getTenant());
        this.elsQueryHeadService.updateMain(elsQueryHead, elsQueryHeadPage.getElsQueryItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.elsQueryHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.elsQueryHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsQueryHead elsQueryHead = (ElsQueryHead)((Object)this.elsQueryHeadService.getById((Serializable)((Object)id)));
        ElsQueryHeadVO elsQueryHeadVO = new ElsQueryHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsQueryHead), (Object)((Object)elsQueryHeadVO));
        List<ElsQueryItem> elsQueryItemList = this.elsQueryItemService.selectByMainId(id);
        elsQueryHeadVO.setElsQueryItemList(elsQueryItemList);
        return Result.ok((Object)((Object)elsQueryHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7tableCode\u67e5\u8be2\u5df2\u4fdd\u5b58\u7684\u67e5\u8be2\u65b9\u6848\u5217\u8868", notes="\u901a\u8fc7tableCode\u67e5\u8be2\u5df2\u4fdd\u5b58\u7684\u67e5\u8be2\u65b9\u6848\u5217\u8868")
    @GetMapping(value={"/queryByTableCode"})
    public Result<?> queryByTableCode(@RequestParam(name="tableCode", required=true) String tableCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"table_code", (Object)tableCode);
        queryWrapper.eq((Object)"sub_account", (Object)this.getCurrentUser().getSubAccount());
        List headList = this.elsQueryHeadService.list((Wrapper)queryWrapper);
        return Result.ok((Object)headList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9ad8\u7ea7\u67e5\u8be2\u5934id\u67e5\u8be2\u9ad8\u7ea7\u67e5\u8be2\u884c", notes="\u901a\u8fc7\u9ad8\u7ea7\u67e5\u8be2\u5934id\u67e5\u8be2\u9ad8\u7ea7\u67e5\u8be2\u884c")
    @GetMapping(value={"/queryElsQueryItemByMainId"})
    public Result<?> queryElsQueryItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsQueryItem> elsQueryItemList = this.elsQueryItemService.selectByMainId(id);
        return Result.ok(elsQueryItemList);
    }

    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u5bfc\u51faxcel", logType=2, operateType=6)
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsQueryHead elsQueryHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsQueryHead), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<ElsQueryHeadVO> pageList = new ArrayList<ElsQueryHeadVO>();
        List elsQueryHeadList = this.elsQueryHeadService.list((Wrapper)queryWrapper);
        for (ElsQueryHead temp : elsQueryHeadList) {
            ElsQueryHeadVO vo = new ElsQueryHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<ElsQueryItem> elsQueryItemList = this.elsQueryItemService.selectByMainId(temp.getId());
            vo.setElsQueryItemList(elsQueryItemList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u9ad8\u7ea7\u67e5\u8be2\u5934");
        mv.addObject("entity", ElsQueryHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u9ad8\u7ea7\u67e5\u8be2\u5934\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u9ad8\u7ea7\u67e5\u8be2\u5934", request.getParameter("defineColumnCode")));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u9ad8\u7ea7\u67e5\u8be2\u5934-\u5bfc\u5165xcel", logType=2, operateType=5)
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<ElsQueryHeadVO> list = ExcelImportUtil.importExcel(file.getInputStream(), ElsQueryHeadVO.class, params);
                for (ElsQueryHeadVO page : list) {
                    ElsQueryHead po = new ElsQueryHead();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.elsQueryHeadService.saveMain(po, page.getElsQueryItemList());
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }
}

