/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.UserColumnDefine;
import com.els.modules.system.service.UserColumnDefineService;
import com.els.modules.system.vo.UserColumnDefineVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u81ea\u5b9a\u4e49\u5217"})
@RestController
@RequestMapping(value={"/base/userColumnDefine"})
public class UserColumnDefineController
extends BaseController<UserColumnDefine, UserColumnDefineService> {
    @Autowired
    private UserColumnDefineService userColumnDefineService;

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u67e5\u8be2\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u67e5\u8be2\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217")
    @GetMapping(value={"/queryCurrentUserColumnDefine/{tableCode}"})
    public Result<?> queryCurrentUserColumnDefine(@PathVariable(value="tableCode") String tableCode, HttpServletRequest req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        List<UserColumnDefineVO> list = this.userColumnDefineService.getUserColumnDefine(sysUser.getId(), tableCode);
        return Result.ok(list);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u67e5\u8be2\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217json", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u67e5\u8be2\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217json")
    @GetMapping(value={"/queryCurrentUserColumnDefineJson/{tableCode}"})
    public Result<?> queryCurrentUserColumnDefineJson(@PathVariable(value="tableCode") String tableCode, HttpServletRequest req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        JSONArray jsonArray = this.userColumnDefineService.getUserColumnDefineJson(sysUser.getId(), tableCode);
        return Result.ok((Object)jsonArray);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u4fdd\u5b58\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u4fdd\u5b58\u5f53\u524d\u7528\u6237\u81ea\u5b9a\u4e49\u5217")
    @PostMapping(value={"/saveCurrentUserColumnDefine/{tableCode}"})
    public Result<?> saveCurrentUserColumnDefine(@PathVariable(value="tableCode") String tableCode, @RequestBody List<UserColumnDefine> userColumnDefineList, HttpServletRequest req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        Date date = new Date();
        for (int i = 0; i < userColumnDefineList.size(); ++i) {
            UserColumnDefine userColumnDefine = userColumnDefineList.get(i);
            userColumnDefine.setUserId(sysUser.getId());
            userColumnDefine.setTableCode(tableCode);
            userColumnDefine.setSortOrder(new BigDecimal(i));
            userColumnDefine.setElsAccount(this.getTenantId());
            userColumnDefine.setCreateBy(sysUser.getSubAccount());
            userColumnDefine.setUpdateBy(sysUser.getSubAccount());
            userColumnDefine.setCreateTime(date);
            userColumnDefine.setUpdateTime(date);
        }
        this.userColumnDefineService.saveUserColumnDefine(userColumnDefineList);
        return this.commonSuccessResult(2);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(UserColumnDefine userColumnDefine, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)userColumnDefine, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.userColumnDefineService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody UserColumnDefine userColumnDefine) {
        this.userColumnDefineService.save(userColumnDefine);
        return this.commonSuccessResult(2);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody UserColumnDefine userColumnDefine) {
        this.userColumnDefineService.updateById(userColumnDefine);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.userColumnDefineService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.userColumnDefineService.removeByIds(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2", notes="\u7528\u6237\u81ea\u5b9a\u4e49\u5217-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        UserColumnDefine userColumnDefine = (UserColumnDefine)this.userColumnDefineService.getById((Serializable)((Object)id));
        return Result.ok((Object)userColumnDefine);
    }

    private String checkDelete(String value) {
        return "success";
    }

    private String checkExist(String dataId, String value) {
        return "success";
    }
}

