/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.utils;

import java.util.regex.Pattern;

public class RegularVerifyUtil {
    private static final Pattern PATTERN_YEAR = Pattern.compile("^[0-9]{4}$");
    private static final Pattern PATTERN_MONTH = Pattern.compile("^(0[1-9])|(1[0-2])$");
    private static final Pattern PATTERN_DAY = Pattern.compile("^(0[1-9])|([1-2][0-9])|(3[0-1])$");

    private RegularVerifyUtil() {
    }

    public static boolean verifyYearStr(String yearStr) {
        return PATTERN_YEAR.matcher(yearStr).matches();
    }

    public static boolean verifyMonthStr(String monthStr) {
        return PATTERN_MONTH.matcher(monthStr).matches();
    }

    public static boolean verifyDayStr(String dayStr) {
        return PATTERN_DAY.matcher(dayStr).matches();
    }
}

