/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.config.mybatis.TenantContext;
import com.els.framework.poi.excel.ExcelImportUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.view.ELSEntityExcelView;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.ElsBarcodeRuleItem;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.ElsBarcodeRuleHeadService;
import com.els.modules.barcode.service.ElsBarcodeRuleItemService;
import com.els.modules.barcode.vo.ElsBarcodeRuleHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeRuleHead"})
@Api(tags={"\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934"})
public class ElsBarcodeRuleHeadController
extends BaseController<ElsBarcodeRuleHead, ElsBarcodeRuleHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsBarcodeRuleHeadController.class);
    @Autowired
    private ElsBarcodeRuleHeadService elsBarcodeRuleHeadService;
    @Autowired
    private ElsBarcodeRuleItemService elsBarcodeRuleItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsBarcodeRuleHead elsBarcodeRuleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.saveMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList());
        return Result.ok((Object)((Object)elsBarcodeRuleHead));
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList(), 1);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList(), 2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeAttributeVO) {
        if ("1".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setRuleStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setRuleStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeAttributeVO), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateById((Object)elsBarcodeRuleHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeRuleHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.elsBarcodeRuleHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadService.getById((Serializable)((Object)id)));
        ElsBarcodeRuleHeadVO elsBarcodeRuleHeadVO = new ElsBarcodeRuleHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHead), (Object)((Object)elsBarcodeRuleHeadVO));
        List<ElsBarcodeRuleItem> elsBarcodeRuleItemList = this.elsBarcodeRuleItemService.selectByMainId(id);
        elsBarcodeRuleHeadVO.setElsBarcodeRuleItemList(elsBarcodeRuleItemList);
        return Result.ok((Object)((Object)elsBarcodeRuleHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934id\u67e5\u8be2\u6761\u7801\u89c4\u5219\u914d\u7f6e\u884c", notes="\u901a\u8fc7\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934id\u67e5\u8be2\u6761\u7801\u89c4\u5219\u914d\u7f6e\u884c")
    @GetMapping(value={"/queryElsBarcodeRuleItemByMainId"})
    public Result<?> queryElsBarcodeRuleItemListByMainId(@RequestParam(name="id") String id) {
        List<ElsBarcodeRuleItem> elsBarcodeRuleItemList = this.elsBarcodeRuleItemService.selectByMainId(id);
        return Result.ok(elsBarcodeRuleItemList);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, ElsBarcodeRuleHead elsBarcodeRuleHead) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleHead), (Map)request.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ArrayList<ElsBarcodeRuleHeadVO> pageList = new ArrayList<ElsBarcodeRuleHeadVO>();
        List elsBarcodeRuleHeadList = this.elsBarcodeRuleHeadService.list((Wrapper)queryWrapper);
        for (ElsBarcodeRuleHead temp : elsBarcodeRuleHeadList) {
            ElsBarcodeRuleHeadVO vo = new ElsBarcodeRuleHeadVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<ElsBarcodeRuleItem> elsBarcodeRuleItemList = this.elsBarcodeRuleItemService.selectByMainId(temp.getId());
            vo.setElsBarcodeRuleItemList(elsBarcodeRuleItemList);
            pageList.add(vo);
        }
        ModelAndView mv = new ModelAndView((View)new ELSEntityExcelView());
        mv.addObject("fileName", (Object)"\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934");
        mv.addObject("entity", ElsBarcodeRuleHeadVO.class);
        mv.addObject("params", (Object)new ExportParams("\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934\u6570\u636e", "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), "\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934"));
        mv.addObject("data", pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List<ElsBarcodeRuleHeadVO> list = ExcelImportUtil.importExcel(file.getInputStream(), ElsBarcodeRuleHeadVO.class, params);
                for (ElsBarcodeRuleHeadVO page : list) {
                    ElsBarcodeRuleHead po = new ElsBarcodeRuleHead();
                    BeanUtils.copyProperties((Object)((Object)page), (Object)((Object)po));
                    this.elsBarcodeRuleHeadService.saveMain(po, page.getElsBarcodeRuleItemList());
                }
                Result result = Result.ok((String)("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570:" + list.size()));
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u5206\u9875\u5934\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5934\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/enabledList"})
    public Result<?> enabledList(ElsBarcodeRuleHead elsBarcodeRuleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ElsBarcodeRuleHead::getRuleStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    public Result<?> itemList(ElsBarcodeRuleItem elsBarcodeRuleItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleItem), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(ElsBarcodeRuleItem::getHeadId, (Object)elsBarcodeRuleItem.getHeadId());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }
}

