/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.imports.sax;

import com.els.common.util.I18nUtil;
import com.els.framework.poi.excel.entity.ImportParams;
import com.els.framework.poi.excel.imports.sax.SheetHandler;
import com.els.framework.poi.excel.imports.sax.parse.ISaxRowRead;
import com.els.framework.poi.excel.imports.sax.parse.SaxRowRead;
import com.els.framework.poi.exception.excel.ExcelImportException;
import com.els.framework.poi.handler.inter.IExcelReadRowHanlder;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxReadExcel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaxReadExcel.class);

    public <T> List<T> readExcel(InputStream inputstream, Class<?> pojoClass, ImportParams params, ISaxRowRead rowRead, IExcelReadRowHanlder hanlder) {
        try {
            OPCPackage opcPackage = OPCPackage.open((InputStream)inputstream);
            return this.readExcel(opcPackage, pojoClass, params, rowRead, hanlder);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(e.getMessage());
        }
    }

    private <T> List<T> readExcel(OPCPackage opcPackage, Class<?> pojoClass, ImportParams params, ISaxRowRead rowRead, IExcelReadRowHanlder hanlder) {
        try {
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            SharedStringsTable sst = xssfReader.getSharedStringsTable();
            if (rowRead == null) {
                rowRead = new SaxRowRead(pojoClass, params, hanlder);
            }
            XMLReader parser = this.fetchSheetParser(sst, rowRead);
            Iterator sheets = xssfReader.getSheetsData();
            for (int sheetIndex = 0; sheets.hasNext() && sheetIndex < params.getSheetNum(); ++sheetIndex) {
                InputStream sheet = (InputStream)sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                parser.parse(sheetSource);
                sheet.close();
            }
            return rowRead.getList();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(I18nUtil.translate((String)"", (String)"SAX\u5bfc\u5165\u6570\u636e\u5931\u8d25"));
        }
    }

    private XMLReader fetchSheetParser(SharedStringsTable sst, ISaxRowRead rowRead) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        SheetHandler handler = new SheetHandler(sst, rowRead);
        parser.setContentHandler(handler);
        return parser;
    }
}

