/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel.export.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.Dict;
import com.els.common.excel.Excel;
import com.els.common.excel.ExcelCollection;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.dict.service.AutoPoiDictServiceI;
import com.els.framework.poi.excel.ExcelExportUtil;
import com.els.framework.poi.excel.entity.ExportFieldAnalysisParams;
import com.els.framework.poi.excel.entity.params.ExcelExportEntity;
import com.els.framework.poi.handler.inter.IExcelDataHandler;
import com.els.framework.poi.util.PoiPublicUtil;
import com.els.modules.system.service.DictService;
import com.els.modules.system.vo.UserColumnDefineVO;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.vo.TemplateHeadVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ColumnDefineExportBase {
    protected IExcelDataHandler dataHanlder;
    protected List<String> needHanlderList;
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");

    private ExcelExportEntity createExcelExportEntity(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(excel.type());
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfConfigHead(String targetId, ExcelExportClassColumnDTO fieldColumn, TemplateConfigHead column) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(targetId, excelEntity, fieldColumn);
        excelEntity.setName(this.getExcelName(column.getFieldName(), targetId));
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(column.getSortOrder()), targetId));
        String format = column.getDataFormat();
        try {
            String filetype = column.getFieldType();
            if (StrUtil.isNotBlank((CharSequence)filetype)) {
                if (filetype.toLowerCase().equals("date")) {
                    format = "yyyy-MM-dd";
                } else if (filetype.toLowerCase().equals("datetime")) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        excelEntity.setFormat(format);
        if (StrUtil.isNotBlank((CharSequence)column.getFieldLabel())) {
            excelEntity.setName(this.getExcelName(column.getFieldLabel(), targetId));
        }
        excelEntity.setFieldColumn(fieldColumn);
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfConfigItem(String targetId, ExcelExportClassColumnDTO fieldColumn, TemplateConfigItem templateItem) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(targetId, excelEntity, fieldColumn);
        excelEntity.setName(this.getExcelName(templateItem.getFieldName(), targetId));
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(templateItem.getSortOrder()), targetId));
        String format = templateItem.getDataFormat();
        try {
            String filetype = templateItem.getFieldType();
            if (StrUtil.isNotBlank((CharSequence)filetype)) {
                if (filetype.toLowerCase().equals("date")) {
                    format = "yyyy-MM-dd";
                } else if (filetype.toLowerCase().equals("datetime")) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        excelEntity.setFormat(format);
        if (StrUtil.isNotBlank((CharSequence)templateItem.getFieldLabel())) {
            excelEntity.setName(this.getExcelName(templateItem.getFieldLabel(), targetId));
        }
        excelEntity.setFieldColumn(fieldColumn);
        return excelEntity;
    }

    private ExcelExportEntity createExcelExportEntityOfDefineColumn(String targetId, ExcelExportClassColumnDTO fieldColumn, UserColumnDefineVO column) throws Exception {
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(1);
        this.getExcelFieldByColumnAndExcel(targetId, excelEntity, fieldColumn);
        excelEntity.setName(this.getExcelName(column.getColumnName(), targetId));
        excelEntity.setOrderNum(this.getCellOrder(String.valueOf(column.getSort()), targetId));
        String format = column.getDataFormat();
        try {
            String filetype = column.getFieldType();
            if (StrUtil.isNotBlank((CharSequence)filetype)) {
                if (filetype.toLowerCase().equals("date")) {
                    format = "yyyy-MM-dd";
                } else if (filetype.toLowerCase().equals("datetime")) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        excelEntity.setFormat(format);
        if (StrUtil.isNotBlank((CharSequence)column.getColumnName())) {
            excelEntity.setName(this.getExcelName(column.getColumnName(), targetId));
        }
        excelEntity.setFieldColumn(fieldColumn);
        return excelEntity;
    }

    private void getExcelFieldByColumnAndExcel(String targetId, ExcelExportEntity excelEntity, ExcelExportClassColumnDTO fieldColumn) throws Exception {
        Excel excel = ExcelAnnotation.class.getDeclaredField("excel").getAnnotation(Excel.class);
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setStatistics(excel.isStatistics());
        excelEntity.setKey(fieldColumn.getFileName());
        excelEntity.setMultiReplace(excel.multiReplace());
    }

    private Object formatValue(Object value, ExcelExportEntity entity) throws Exception {
        SimpleDateFormat format;
        Date temp = null;
        if (value instanceof String) {
            format = new SimpleDateFormat(entity.getDatabaseFormat());
            temp = format.parse(value.toString());
        } else if (value instanceof Date) {
            temp = (Date)value;
        }
        if (temp != null) {
            format = new SimpleDateFormat(entity.getFormat());
            value = format.format(temp);
        }
        return value;
    }

    public void filterExcelFieldByColumnDefine(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, List<UserColumnDefineVO> userColumnDefine, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        HashMap defineColumnList = Maps.newHashMap();
        int size = userColumnDefine.size();
        for (int index = 0; index < size; ++index) {
            UserColumnDefineVO defineVO = userColumnDefine.get(index);
            if (defineVO.getHidden() != 0) continue;
            String columnCode = defineVO.getColumnCode();
            defineVO.setColumnCode(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            defineVO.setSort(index - 1 - size);
            defineColumnList.put(defineVO.getColumnCode(), defineVO);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, defineVO.getColumnName());
            if (!exist) continue;
            defineColumnList.remove(defineVO.getColumnCode());
        }
        for (UserColumnDefineVO c : userColumnDefine) {
            if (!defineColumnList.containsKey(c.getColumnCode())) continue;
            UserColumnDefineVO defineVO = (UserColumnDefineVO)defineColumnList.get(c.getColumnCode());
            ExcelExportClassColumnDTO fieldColumn = classColumnList.get(defineVO.getColumnCode());
            excelParams.add(this.createExcelExportEntityOfDefineColumn(targetId, fieldColumn, defineVO));
        }
    }

    public void filterExcelFieldByTemplateHead(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, TemplateHeadVO templateHeadVO, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        List<TemplateConfigHead> columnList = templateHeadVO.getTemplateConfigHeadList();
        HashMap defineColumnList = Maps.newHashMap();
        int size = columnList.size();
        for (int index = 0; index < size; ++index) {
            Object head = columnList.get(index);
            if ("0".equals(head.getPurchaseShow()) && "0".equals(head.getSaleShow())) continue;
            String columnCode = head.getFieldName();
            head.setFieldName(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            head.setSortOrder(index - 1 - size);
            defineColumnList.put(head.getFieldName(), head);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, head.getFieldName());
            if (!exist) continue;
            defineColumnList.remove(head.getFieldName());
        }
        ArrayList collectionField = Lists.newArrayList();
        for (TemplateConfigHead c : columnList) {
            ExcelExportClassColumnDTO columnDTO;
            if (defineColumnList.containsKey(c.getFieldName())) {
                TemplateConfigHead configHead = (TemplateConfigHead)((Object)defineColumnList.get(c.getFieldName()));
                ExcelExportClassColumnDTO fieldColumn = classColumnList.get(configHead.getFieldName());
                excelParams.add(this.createExcelExportEntityOfConfigHead(targetId, fieldColumn, configHead));
            }
            if (null == (columnDTO = classColumnList.get(c.getFieldName())) || !BooleanUtil.isTrue((Boolean)columnDTO.getCollection())) continue;
            collectionField.add(columnDTO);
        }
        List group = classColumnList.values().stream().filter(x -> BooleanUtil.isTrue((Boolean)x.getCollection())).collect(Collectors.toList());
        int gSize = group.size();
        for (int i = gSize - 1; i >= 0; --i) {
            this.filterCollectionColumn(targetId, (ExcelExportClassColumnDTO)group.get(i), excelParams, fieldAnalysisParams, templateHeadVO);
        }
    }

    public void filterExcelFieldByTemplateItem(String targetId, List<ExcelExportEntity> excelParams, Map<String, ExcelExportClassColumnDTO> classColumnList, List<TemplateConfigItem> columnList, ExportFieldAnalysisParams fieldAnalysisParams) throws Exception {
        HashMap defineColumnList = Maps.newHashMap();
        int size = columnList.size();
        for (int index = 0; index < size; ++index) {
            TemplateConfigItem head = (TemplateConfigItem)((Object)Convert.convert(TemplateConfigItem.class, (Object)((Object)columnList.get(index))));
            if ("0".equals(head.getPurchaseShow()) && "0".equals(head.getSaleShow())) continue;
            String columnCode = head.getFieldName();
            head.setFieldName(columnCode.endsWith("_dictText") ? columnCode.substring(0, columnCode.indexOf("_dictText")) : columnCode);
            head.setSortOrder(index - 1 - size);
            defineColumnList.put(head.getFieldName(), head);
            boolean exist = this.columnFilterCheck(fieldAnalysisParams, head.getFieldName());
            if (!exist) continue;
            defineColumnList.remove(head.getFieldName());
        }
        for (String key : defineColumnList.keySet()) {
            TemplateConfigItem templateConfigItem = (TemplateConfigItem)((Object)defineColumnList.get(key));
            ExcelExportClassColumnDTO fieldColumn = classColumnList.get(key);
            if (null == fieldColumn) continue;
            excelParams.add(this.createExcelExportEntityOfConfigItem(targetId, fieldColumn, templateConfigItem));
        }
    }

    private void filterCollectionColumn(String targetId, ExcelExportClassColumnDTO column, List<ExcelExportEntity> excelParams, ExportFieldAnalysisParams fieldAnalysisParams, TemplateHeadVO templateHeadVO) throws Exception {
        Map<String, ExcelExportClassColumnDTO> classColumnList;
        ExcelCollection excel = column.getExcelCollection();
        List childrenColumn = column.getChildren();
        List<TemplateGroup> templateGroupList = templateHeadVO.getTemplateGroupList();
        String fileName = column.getFileName();
        TemplateGroup g = null;
        for (TemplateGroup group : templateGroupList) {
            if (!fileName.equals(group.getGroupCode())) continue;
            g = group;
            break;
        }
        if (null == g) {
            g = new TemplateGroup();
            g.setGroupName(column.getFileName());
            g.setGroupCode(column.getFileName());
            if (null != excel && CharSequenceUtil.isNotEmpty((CharSequence)excel.name())) {
                g.setGroupName(excel.name());
            }
            g.setSortOrder(null);
        }
        if (CollUtil.isEmpty(classColumnList = childrenColumn.stream().collect(Collectors.toMap(ExcelExportClassColumnDTO::getFileName, Function.identity(), (v1, v2) -> v2)))) {
            return;
        }
        ArrayList removeKey = Lists.newArrayList();
        if (null != excel) {
            String[] ignorePres = excel.ignorePrefix();
            for (int i = 0; i < ignorePres.length; ++i) {
                Set<String> keyColumn = classColumnList.keySet();
                for (String f : keyColumn) {
                    if (!StrUtil.isNotBlank((CharSequence)f) || !f.startsWith(ignorePres[i])) continue;
                    removeKey.add(f);
                }
            }
        }
        if (CollUtil.isEmpty(classColumnList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        targetId = null != excel && StringUtils.isNotEmpty((String)excel.id()) ? excel.id() : targetId;
        List<TemplateConfigItem> templateConfigItemList = templateHeadVO.getTemplateConfigItemList();
        List<TemplateConfigItem> itemList = null;
        if (CollUtil.isNotEmpty(templateConfigItemList)) {
            itemList = templateConfigItemList.stream().filter(x -> column.getFileName().equals(x.getGroupCode())).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(itemList)) {
            itemList = childrenColumn.stream().map(x -> {
                TemplateConfigItem t = new TemplateConfigItem();
                t.setFieldName(x.getFileName());
                t.setFieldType(x.getFileType());
                t.setGroupCode(column.getFileName());
                t.setFieldLabel(x.getFileName());
                Dict dict = x.getDict();
                if (null != dict) {
                    t.setDictCode("dict_$$@#!%^");
                }
                return t;
            }).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        int size = itemList.size();
        for (int i = size - 1; i >= 0; --i) {
            TemplateConfigItem item = (TemplateConfigItem)((Object)itemList.get(i));
            if (!removeKey.contains(item.getFieldName())) continue;
            itemList.remove(i);
        }
        this.filterExcelFieldByTemplateItem(targetId, list, classColumnList, itemList, fieldAnalysisParams);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setName(this.getExcelName(g.getGroupName(), targetId));
        excelEntity.setOrderNum(this.getCellOrder(null == g.getSortOrder() ? "" : g.getSortOrder() + "", targetId));
        excelEntity.setKey(column.getFileName());
        excelEntity.setList(list);
        excelParams.add(excelEntity);
    }

    private boolean columnFilterCheck(ExportFieldAnalysisParams fieldAnalysisParams, String columnTitle) {
        boolean exist = false;
        return exist;
    }

    public int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (this.isInteger(orderNum) && targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            String[] temp = str.split("_");
            if (temp.length <= 1 || !targetId.equals(temp[1])) continue;
            return Integer.valueOf(temp[0]);
        }
        return 0;
    }

    public Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value = null;
        if (obj instanceof JSONObject) {
            Object entityValue = ((JSONObject)obj).get(entity.getKey());
            value = this.getDictFieldValue(entityValue, entity, obj);
        } else if (obj instanceof Map) {
            value = ((Map)obj).get(entity.getKey());
        } else {
            Object entityValue = ((JSONObject)obj).get(entity.getKey());
            value = this.getDictFieldValue(entityValue, entity, obj);
        }
        if (StringUtils.isNotEmpty((String)entity.getFormat())) {
            value = this.formatValue(value, entity);
        }
        if (entity.getReplace() != null && entity.getReplace().length > 0) {
            if (value == null) {
                value = "";
            }
            value = entity.isMultiReplace() ? this.multiReplaceValue(entity.getReplace(), String.valueOf(value)) : this.replaceValue(entity.getReplace(), String.valueOf(value));
        }
        if (this.needHanlderList != null && this.needHanlderList.contains(entity.getName())) {
            value = this.dataHanlder.exportHandler(obj, entity.getName(), value);
        }
        if (StringUtils.isNotEmpty((String)entity.getSuffix()) && value != null) {
            value = value + entity.getSuffix();
        }
        return value == null ? "" : value.toString();
    }

    private Object getDictFieldValue(Object entityValue, ExcelExportEntity entity, Object obj) {
        try {
            ExcelExportClassColumnDTO fieldColumn = entity.getFieldColumn();
            if (null == fieldColumn || null == fieldColumn.getDict()) {
                return entityValue;
            }
            Dict dictAnnotation = fieldColumn.getDict();
            ExcelExportUtil.initThreadDictMap();
            String fieldNameValue = ExcelExportUtil.getThreadDictMapValue().get(fieldColumn.getFileName() + "_" + entityValue);
            if (null != fieldNameValue) {
                return fieldNameValue;
            }
            JSONObject item = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
            String busAccount = item.getString("busAccount");
            if (StrUtil.isBlank((CharSequence)busAccount)) {
                busAccount = TenantContext.getTenant();
            }
            boolean isFilterSql = false;
            String code = dictAnnotation.dicCode();
            String text = dictAnnotation.dicText();
            String table = dictAnnotation.dictTable();
            if (code.contains("${")) {
                StringBuffer filterSql = new StringBuffer();
                Matcher matcher = this.pattern.matcher(code);
                isFilterSql = true;
                while (matcher.find()) {
                    matcher.appendReplacement(filterSql, item.get((Object)matcher.group(1)) + "");
                }
                matcher.appendTail(filterSql);
                code = filterSql.toString();
            }
            String key = String.valueOf(entityValue);
            String textValue = this.translateDictValue(code, text, table, key, isFilterSql, busAccount);
            ExcelExportUtil.setThreadDictMapValue(fieldColumn.getFileName() + "_" + entityValue, textValue);
            return textValue;
        }
        catch (Exception exception) {
            return entityValue;
        }
    }

    private Field getObjField(Object obj, String fieldName) {
        Field field = null;
        for (Class<?> modalClass = obj.getClass(); modalClass != null && !modalClass.getName().toLowerCase().equals("java.lang.object"); modalClass = modalClass.getSuperclass()) {
            try {
                field = modalClass.getDeclaredField(fieldName);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return field;
    }

    private String translateDictValue(String code, String text, String table, String key, boolean isFilterSql, String busAccount) {
        String[] keys;
        if (StrUtil.isEmpty((CharSequence)key)) {
            return null;
        }
        StringBuffer textValue = new StringBuffer();
        for (String k : keys = key.split(",")) {
            String tmpValue = null;
            if (k.trim().length() == 0 || (tmpValue = isFilterSql ? ((DictService)SpringContextUtils.getBean(DictService.class)).queryTableDictTextByFilterSql(table, text, code, busAccount) : ((DictService)SpringContextUtils.getBean(DictService.class)).queryDictTextByKey(code, k.trim(), busAccount)) == null) continue;
            if (!"".equals(textValue.toString())) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }

    public Collection<?> getListCellValue(ExcelExportEntity entity, Object dataObj) throws Exception {
        Object value = dataObj instanceof Map ? ((Map)dataObj).get(entity.getKey()) : (Collection)entity.getMethod().invoke(dataObj, new Object[0]);
        return (Collection)value;
    }

    private void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(this.getExcelName(excel.name(), targetId));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        if (StringUtils.isNotEmpty((String)excel.dicCode())) {
            AutoPoiDictServiceI ilsDictService = null;
            try {
                ilsDictService = (AutoPoiDictServiceI)SpringContextUtils.getBean(AutoPoiDictServiceI.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ilsDictService != null) {
                String[] dictReplace = ilsDictService.queryDict(excel.dictTable(), excel.dicCode(), excel.dicText());
                if (excelEntity.getReplace() != null && dictReplace != null && dictReplace.length != 0) {
                    excelEntity.setReplace(dictReplace);
                }
            }
        }
        excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setFormat(StringUtils.isNotEmpty((String)excel.exportFormat()) ? excel.exportFormat() : excel.format());
        excelEntity.setStatistics(excel.isStatistics());
        String fieldname = field.getName();
        excelEntity.setMethod(PoiPublicUtil.getMethod(fieldname, pojoClass, excel.exportConvert()));
        excelEntity.setMultiReplace(excel.multiReplace());
    }

    public String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0 || targetId == null) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    @Deprecated
    public Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    public short getRowHeight(List<ExcelExportEntity> excelParams) {
        double maxHeight = 0.0;
        for (int i = 0; i < excelParams.size(); ++i) {
            maxHeight = Math.max(maxHeight, excelParams.get(i).getHeight());
            if (excelParams.get(i).getList() == null) continue;
            for (int j = 0; j < excelParams.get(i).getList().size(); ++j) {
                maxHeight = Math.max(maxHeight, excelParams.get(i).getList().get(j).getHeight());
            }
        }
        return (short)(maxHeight * 50.0);
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private Object replaceValue(String[] replace, String value) {
        for (String str : replace) {
            String[] temp = str.split("_");
            if (!value.equals(temp[1])) continue;
            value = temp[0];
            break;
        }
        return value;
    }

    private Object multiReplaceValue(String[] replace, String value) {
        if (value.indexOf(",") > 0) {
            String[] radioVals = value.split(",");
            String result = "";
            block0: for (int i = 0; i < radioVals.length; ++i) {
                String radio = radioVals[i];
                for (String str : replace) {
                    String[] temp = str.split("_");
                    if (!radio.equals(temp[1])) continue;
                    result = result.concat(temp[0]) + ",";
                    continue block0;
                }
            }
            result = result.equals("") ? value : result.substring(0, result.length() - 1);
            return result;
        }
        return this.replaceValue(replace, value);
    }

    public void sortExportColumn(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams);
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList());
        }
    }

    static class ExcelAnnotation {
        @Excel(width=20.0)
        private String excel;

        ExcelAnnotation() {
        }
    }
}

