/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.excel.ExcelExportDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.framework.poi.excel.entity.ExportParams;
import com.els.framework.poi.excel.view.ELSColumnDefineEntityExcelView;
import com.els.modules.base.api.enumerate.PurchaseReportParamEnum;
import com.els.modules.base.api.service.ExcelExportRpcService;
import com.els.modules.system.rpc.service.BaseInvokeExcelExportExecuteService;
import com.els.modules.system.service.ExcelReportService;
import com.els.modules.system.service.UserColumnDefineService;
import com.els.modules.system.vo.UserColumnDefineVO;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.vo.TemplateHeadVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Service
public class ExcelReportServiceImpl
implements ExcelReportService {
    @Resource
    private BaseInvokeExcelExportExecuteService baseInvokeExcelExportExecuteService;
    @Autowired
    private UserColumnDefineService userColumnDefineService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;

    @Override
    public ModelAndView exportXls(HttpServletRequest request, Map<String, Object> object, String handlerName) {
        String templateId;
        String fileName = request.getParameter("fileName");
        String exportType = request.getParameter("exportType");
        LoginUser sysUser = SysUtil.getLoginUser();
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        ExportParams exportParams = new ExportParams();
        if ("head_item".equals(exportType)) {
            templateId = request.getParameter("templateId");
            if (StrUtil.isEmpty((CharSequence)templateId)) {
                throw new ELSBootException("", new String[]{"\u8bf7\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f"});
            }
            TemplateHeadVO templateHeadVO = this.templateHeadService.selectVoById(templateId);
            exportParams.setTemplateHeadVO(templateHeadVO);
        } else if ("item".equals(exportType)) {
            templateId = request.getParameter("templateId");
            if (StrUtil.isEmpty((CharSequence)templateId)) {
                throw new ELSBootException("", new String[]{"\u8bf7\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f"});
            }
            List<TemplateConfigItem> templateConfigItems = this.templateConfigItemService.selectByMainId(templateId);
            exportParams.setTemplateConfigItemList(templateConfigItems);
        } else {
            String defineColumnCode = request.getParameter("defineColumnCode");
            List<UserColumnDefineVO> userColumnDefine = this.userColumnDefineService.getUserColumnDefine(sysUser.getId(), defineColumnCode);
            this.filterColumnDefine(userColumnDefine);
            if (CollUtil.isEmpty(userColumnDefine)) {
                throw new ELSBootException("", new String[]{"\u65e0\u53ef\u5c55\u793a\u5217\u5185\u5bb9"});
            }
            exportParams.setColumnDefineVoList(userColumnDefine);
        }
        ExcelExportRpcService excelExportRpcService = this.baseInvokeExcelExportExecuteService.getExcelExportRpcService(handlerName);
        hashMap.put(PurchaseReportParamEnum.ENTITY.getValue(), object);
        ExcelExportDTO excelExportDTO = excelExportRpcService.exportXlsParam(hashMap, request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new ELSColumnDefineEntityExcelView());
        mv.addObject("fileName", (Object)fileName);
        exportParams.setTitle(fileName + "\u62a5\u8868");
        exportParams.setSecondTitle("\u5bfc\u51fa\u4eba:" + sysUser.getRealname());
        exportParams.setSheetName(fileName);
        exportParams.setClassColumnList(excelExportDTO.getColumnList());
        exportParams.setExportType(exportType);
        mv.addObject("params", (Object)exportParams);
        List dataList = JSONArray.parseArray((String)excelExportDTO.getDataJson(), JSONObject.class);
        mv.addObject("data", (Object)dataList);
        return mv;
    }

    private void filterColumnDefine(List<UserColumnDefineVO> userColumnDefine) {
        int size;
        for (int i = size = userColumnDefine.size() - 1; i >= 0; --i) {
            UserColumnDefineVO vo = userColumnDefine.get(i);
            if (vo.getHidden() == 0) continue;
            userColumnDefine.remove(i);
        }
    }
}

