/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.ElsBarcodeRuleItem;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleItemMapper;
import com.els.modules.barcode.service.ElsBarcodeRuleHeadService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsBarcodeRuleHeadServiceImpl
extends BaseServiceImpl<ElsBarcodeRuleHeadMapper, ElsBarcodeRuleHead>
implements ElsBarcodeRuleHeadService {
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private ElsBarcodeRuleItemMapper elsBarcodeRuleItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) {
        List<String> ruleCodeList = this.elsBarcodeRuleHeadMapper.listRuleCode(TenantContext.getTenant());
        if (ruleCodeList.size() >= 999) {
            Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_ToLFERWRWWWTWVQGxjjToLFSKcI_af335f49", (String)"\u6761\u7801\u89c4\u5219\u914d\u7f6e\u9650\u5236999\u6761\uff0c\u8bf7\u5220\u9664\u4e0d\u7528\u7684\u6761\u7801\u89c4\u5219\u540e\u518d\u521b\u5efa"));
        }
        String ruleCode = "001";
        for (int i = 1; i <= 999; ++i) {
            if (ruleCodeList.contains(String.format("%03d", i))) continue;
            ruleCode = String.format("%03d", i);
            break;
        }
        elsBarcodeRuleHead.setRuleCode(ruleCode);
        elsBarcodeRuleHead.setRuleStatus(SrmEnabledStatusEnum.NEW.getValue());
        elsBarcodeRuleHead.setRuleNumber(this.codeGeneratorService.getNextCode("srmBarcodeRuleNumber", (Object)elsBarcodeRuleHead));
        if (StringUtils.isBlank((CharSequence)elsBarcodeRuleHead.getEncrypt())) {
            elsBarcodeRuleHead.setEncrypt("0");
        }
        this.elsBarcodeRuleHeadMapper.insert((Object)elsBarcodeRuleHead);
        this.insertData(elsBarcodeRuleHead, elsBarcodeRuleItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList, Integer type) {
        if (type != null && 2 == type) {
            elsBarcodeRuleHead.setRuleStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        }
        this.elsBarcodeRuleHeadMapper.updateById((Object)elsBarcodeRuleHead);
        this.elsBarcodeRuleItemMapper.deleteByMainId(elsBarcodeRuleHead.getId());
        this.insertData(elsBarcodeRuleHead, elsBarcodeRuleItemList);
    }

    private void insertData(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) {
        if (elsBarcodeRuleItemList != null && !elsBarcodeRuleItemList.isEmpty()) {
            int itemNum = 1;
            for (ElsBarcodeRuleItem entity : elsBarcodeRuleItemList) {
                entity.setHeadId(elsBarcodeRuleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsBarcodeRuleHead);
                entity.setItemNumber(Integer.toString(itemNum));
                entity.setId(null);
                ++itemNum;
            }
            this.elsBarcodeRuleItemMapper.insertBatchSomeColumn(elsBarcodeRuleItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsBarcodeRuleItemMapper.deleteByMainId(id);
        this.elsBarcodeRuleHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsBarcodeRuleItemMapper.deleteByMainId(serializable.toString());
            this.elsBarcodeRuleHeadMapper.deleteById(serializable);
        }
    }
}

