/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarCodeParamConfig;
import com.els.modules.barcode.enumerate.ElsBarCodeParamConfigEnum;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeParamConfigMapper;
import com.els.modules.barcode.service.ElsBarCodeParamConfigService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsBarCodeParamConfigServiceImpl
extends BaseServiceImpl<ElsBarCodeParamConfigMapper, ElsBarCodeParamConfig>
implements ElsBarCodeParamConfigService {
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    public void saveElsBarCodeParamConfig(ElsBarCodeParamConfig elsBarCodeParamConfig) {
        elsBarCodeParamConfig.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_NEW.value());
        elsBarCodeParamConfig.setParamSerialNumber(this.codeGeneratorService.getNextCode("srmBarcodeParamNumber", (Object)elsBarCodeParamConfig));
        ((ElsBarCodeParamConfigMapper)this.baseMapper).insert((Object)elsBarCodeParamConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateElsBarCodeParamConfig(ElsBarCodeParamConfig elsBarCodeParamConfig) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)elsBarCodeParamConfig.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)elsBarCodeParamConfig.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        int countNum = ((ElsBarCodeParamConfigMapper)this.baseMapper).countByDocType(elsBarCodeParamConfig.getId(), elsBarCodeParamConfig.getBusDocType(), TenantContext.getTenant());
        AssertI18nUtil.isTrue((countNum > 0 ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.PARAM_SAME_DOC_TYPE);
        ElsBarCodeParamConfig updateRecord = new ElsBarCodeParamConfig();
        BeanUtils.copyProperties((Object)((Object)elsBarCodeParamConfig), (Object)((Object)updateRecord));
        updateRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        if (StringUtils.isBlank((CharSequence)elsBarCodeParamConfig.getBusDocType())) {
            updateRecord.setBusDocType(null);
            updateRecord.setDefaultParam("1");
        } else {
            updateRecord.setDefaultParam("0");
        }
        ((ElsBarCodeParamConfigMapper)this.baseMapper).updateById((Object)updateRecord);
    }

    @Override
    public void operaOn(String id) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        oldRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
        ((ElsBarCodeParamConfigMapper)this.baseMapper).updateById((Object)oldRecord);
    }

    @Override
    public void operaOff(String id) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_OFF.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_OFF);
        oldRecord.setStatus(ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_OFF.value());
        ((ElsBarCodeParamConfigMapper)this.baseMapper).updateById((Object)oldRecord);
    }

    @Override
    public void delElsBarCodeParamConfig(String id) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        ((ElsBarCodeParamConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsBarCodeParamConfig(List<String> idList) {
        for (String id : idList) {
            ElsBarCodeParamConfig oldRecord = (ElsBarCodeParamConfig)((Object)((ElsBarCodeParamConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
            AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            AssertI18nUtil.isTrue((boolean)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value().equals(oldRecord.getStatus()), (Enum)I18nBarCodeEnum.PARAM_STAUS_IS_ON);
        }
        ((ElsBarCodeParamConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

