/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.enumerate;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionTypeEnum {
    NO("0", "\u52a0\u5bc6\u7c7b\u578b-\u4e0d\u52a0\u5bc6"),
    DES("1", "\u52a0\u5bc6\u7c7b\u578b-DES\u52a0\u5bc6"),
    THREE_DES("2", "\u52a0\u5bc6\u7c7b\u578b-3DES\u52a0\u5bc6"),
    AES("3", "\u52a0\u5bc6\u7c7b\u578b-AES\u52a0\u5bc6"),
    RSA("4", "\u52a0\u5bc6\u7c7b\u578b-RSA\u52a0\u5bc6"),
    DSA("5", "\u52a0\u5bc6\u7c7b\u578b-DSA\u52a0\u5bc6");

    private final String value;
    private final String desc;
    private static final Map<String, EncryptionTypeEnum> enumMap;

    public String value() {
        return this.value;
    }

    private EncryptionTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static EncryptionTypeEnum of(String value) {
        EncryptionTypeEnum typeEnum = enumMap.get(value);
        AssertI18nUtil.isTrue((typeEnum == null ? 1 : 0) != 0, (Enum)I18nBarCodeEnum.ENCRYPTION_TYPE_NOT_FOUND);
        return typeEnum;
    }

    static {
        enumMap = Stream.of(EncryptionTypeEnum.values()).collect(Collectors.toMap(EncryptionTypeEnum::value, e -> e));
    }
}

