/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.els.modules.attachment.oss.OSSClientFactory;
import com.els.modules.attachment.oss.OSSConfigure;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSManageUtil {
    private static final Logger logger = LoggerFactory.getLogger(OSSManageUtil.class);
    private static OSSConfigure configure = OSSConfigure.getOOSconfigure();

    private OSSManageUtil() {
    }

    public static String uploadFile(File file, String remotePath) throws Exception {
        try (FileInputStream fileContent = null;){
            fileContent = new FileInputStream(file);
            OSSClient ossClient = OSSClientFactory.create();
            String remoteFilePath = remotePath.substring(0, remotePath.length()).replaceAll("\\\\", "/") + "/";
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)((InputStream)fileContent).available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OSSManageUtil.contentType(file.getName().substring(file.getName().lastIndexOf("."))));
            objectMetadata.setContentDisposition("inline;filename=" + file.getName());
            PutObjectResult result = ossClient.putObject(configure.getBucketName(), remoteFilePath + file.getName(), (InputStream)fileContent, objectMetadata);
            System.out.println("etag = " + result.getETag());
            System.out.println(configure.getAccessUrl() + "/" + remoteFilePath + file.getName());
            logger.info("uploadFile Successful! etag = " + result.getETag() + " filePath: " + configure.getAccessUrl() + "/" + remoteFilePath + remoteFilePath);
            String string = configure.getAccessUrl() + "/" + remoteFilePath + file.getName();
            return string;
        }
    }

    public static OSSObject downloadFile(String remotePath) throws Exception {
        OSSClient ossClient = OSSClientFactory.create();
        OSSObject object = ossClient.getObject(configure.getBucketName(), remotePath);
        return object;
    }

    public static void deleteFile(String filePath) {
        OSSClient ossClient = OSSClientFactory.create();
        ossClient.deleteObject(configure.getBucketName(), filePath);
        logger.info("Delete File Successful ! filePath :" + filePath);
    }

    public static String contentType(String FilenameExtension) {
        if (FilenameExtension.equals("BMP") || FilenameExtension.equals("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.equals("GIF") || FilenameExtension.equals("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.equals("JPEG") || FilenameExtension.equals("jpeg") || FilenameExtension.equals("JPG") || FilenameExtension.equals("jpg") || FilenameExtension.equals("PNG") || FilenameExtension.equals("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.equals("HTML") || FilenameExtension.equals("html")) {
            return "text/html";
        }
        if (FilenameExtension.equals("TXT") || FilenameExtension.equals("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.equals("VSD") || FilenameExtension.equals("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.equals("PPTX") || FilenameExtension.equals("pptx") || FilenameExtension.equals("PPT") || FilenameExtension.equals("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.equals("DOCX") || FilenameExtension.equals("docx") || FilenameExtension.equals("DOC") || FilenameExtension.equals("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.equals("XML") || FilenameExtension.equals("xml")) {
            return "text/xml";
        }
        return "text/html";
    }

    public static String uploadFile(byte[] bytes, String fileName, String remotePath) {
        OSSClient ossClient = OSSClientFactory.create();
        String remoteFilePath = remotePath.substring(0, remotePath.length()).replaceAll("\\\\", "/") + "/";
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)bytes.length);
        objectMetadata.setCacheControl("no-cache");
        objectMetadata.setHeader("Pragma", (Object)"no-cache");
        objectMetadata.setContentType(OSSManageUtil.contentType(fileName.substring(fileName.lastIndexOf("."))));
        objectMetadata.setContentDisposition("inline;filename=" + fileName);
        ossClient.putObject(configure.getBucketName(), remoteFilePath + fileName, (InputStream)new ByteArrayInputStream(bytes));
        ossClient.shutdown();
        return configure.getAccessUrl() + "/" + remoteFilePath + fileName;
    }
}

