/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static void main(String[] args) {
        ArrayList<Map<String, String>> result = ExcelUtil.readExcelToObj("D:\\\u4e0a\u4f20\u8868.xlsx");
        for (Map<String, String> map : result) {
            System.out.println(map);
        }
    }

    public static ArrayList<Map<String, String>> readExcelToObj(String path) {
        Workbook wb = null;
        ArrayList<Map<String, String>> result = null;
        try {
            wb = WorkbookFactory.create((File)new File(path));
            result = ExcelUtil.readExcel(wb, 0, 2, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<Map<String, String>> readExcel(Workbook wb, int sheetIndex, int startReadLine, int tailLine) {
        Sheet sheet = wb.getSheetAt(sheetIndex);
        Row row = null;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (int i = startReadLine; i < sheet.getLastRowNum() - tailLine + 1; ++i) {
            row = sheet.getRow(i);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Cell c : row) {
                String rs;
                String returnStr = "";
                boolean isMerge = ExcelUtil.isMergedRegion(sheet, i, c.getColumnIndex());
                returnStr = isMerge ? (rs = ExcelUtil.getMergedRegionValue(sheet, row.getRowNum(), c.getColumnIndex())) : c.getRichStringCellValue().getString();
                if (c.getColumnIndex() == 0) {
                    map.put("id", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 1) {
                    map.put("base", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 2) {
                    map.put("siteName", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 3) {
                    map.put("articleName", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 4) {
                    map.put("mediaName", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 5) {
                    map.put("mediaUrl", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 6) {
                    map.put("newsSource", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 7) {
                    map.put("isRecord", returnStr);
                    continue;
                }
                if (c.getColumnIndex() == 8) {
                    map.put("recordTime", returnStr);
                    continue;
                }
                if (c.getColumnIndex() != 9) continue;
                map.put("remark", returnStr);
            }
            result.add(map);
        }
        return result;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return ExcelUtil.getCellValue(fCell);
        }
        return null;
    }

    public static boolean isMergedRow(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row != firstRow || row != lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMerged(Sheet sheet) {
        return sheet.getNumMergedRegions() > 0;
    }

    public static void mergeRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public static String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return "";
    }

    public static String remove0Suffix(Object value) {
        if (value != null) {
            String val = value.toString();
            if (val.endsWith(".0")) {
                val = val.replace(".0", "");
            }
            return val;
        }
        return null;
    }

    public static void readContent(String fileName) {
        boolean isE2007 = false;
        if (fileName.endsWith("xlsx")) {
            isE2007 = true;
        }
        try {
            FileInputStream input = new FileInputStream(fileName);
            Object wb = null;
            wb = isE2007 ? new XSSFWorkbook((InputStream)input) : new HSSFWorkbook((InputStream)input);
            Sheet sheet = wb.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                System.out.println("Row #" + row.getRowNum());
                Iterator cells = row.cellIterator();
                while (cells.hasNext()) {
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

