/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.word.parse.excel;

import com.els.framework.poi.util.PoiPublicUtil;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public final class ExcelMapParse {
    private static String[] parseCurrentRowGetParams(XWPFTableRow currentRow) {
        List cells = currentRow.getTableCells();
        String[] params = new String[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            String text = ((XWPFTableCell)cells.get(i)).getText();
            params[i] = text == null ? "" : text.trim().replace("{{", "").replace("}}", "");
        }
        return params;
    }

    public static void parseNextRowAndAddRow(XWPFTable table, int index, List<Object> list) throws Exception {
        XWPFTableRow currentRow = table.getRow(index);
        String[] params = ExcelMapParse.parseCurrentRowGetParams(currentRow);
        table.removeRow(index);
        int cellIndex = 0;
        for (Object obj : list) {
            currentRow = table.createRow();
            for (cellIndex = 0; cellIndex < currentRow.getTableCells().size(); ++cellIndex) {
                ((XWPFTableCell)currentRow.getTableCells().get(cellIndex)).setText(PoiPublicUtil.getValueDoWhile(obj, params[cellIndex].split("\\."), 0).toString());
            }
            while (cellIndex < params.length) {
                currentRow.createCell().setText(PoiPublicUtil.getValueDoWhile(obj, params[cellIndex].split("\\."), 0).toString());
                ++cellIndex;
            }
        }
    }
}

