/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.entity.PurchaseBarcodePoolItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolItemMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolRecordMapper;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodePoolHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodePoolHeadMapper, PurchaseBarcodePoolHead>
implements PurchaseBarcodePoolHeadService {
    @Autowired
    private PurchaseBarcodePoolHeadMapper purchaseBarcodePoolHeadMapper;
    @Autowired
    private PurchaseBarcodePoolItemMapper purchaseBarcodePoolItemMapper;
    @Autowired
    private PurchaseBarcodePoolRecordMapper purchaseBarcodePoolRecordMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        this.purchaseBarcodePoolHeadMapper.insert((Object)purchaseBarcodePoolHead);
        this.insertData(purchaseBarcodePoolHead, purchaseBarcodePoolItemList, purchaseBarcodePoolRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        this.purchaseBarcodePoolHeadMapper.updateById((Object)purchaseBarcodePoolHead);
        this.purchaseBarcodePoolItemMapper.deleteByMainId(purchaseBarcodePoolHead.getId());
        this.purchaseBarcodePoolRecordMapper.deleteByMainId(purchaseBarcodePoolHead.getId());
        this.insertData(purchaseBarcodePoolHead, purchaseBarcodePoolItemList, purchaseBarcodePoolRecordList);
    }

    private void insertData(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        for (PurchaseBarcodePoolItem purchaseBarcodePoolItem : purchaseBarcodePoolItemList) {
            purchaseBarcodePoolItem.setHeadId(purchaseBarcodePoolHead.getId());
            SysUtil.setSysParam((BaseEntity)purchaseBarcodePoolItem, (BaseEntity)purchaseBarcodePoolHead);
        }
        if (!purchaseBarcodePoolItemList.isEmpty()) {
            this.purchaseBarcodePoolItemMapper.insertBatchSomeColumn(purchaseBarcodePoolItemList);
        }
        for (PurchaseBarcodePoolRecord purchaseBarcodePoolRecord : purchaseBarcodePoolRecordList) {
            purchaseBarcodePoolRecord.setHeadId(purchaseBarcodePoolHead.getId());
            SysUtil.setSysParam((BaseEntity)purchaseBarcodePoolRecord, (BaseEntity)purchaseBarcodePoolHead);
        }
        if (!purchaseBarcodePoolRecordList.isEmpty()) {
            this.purchaseBarcodePoolRecordMapper.insertBatchSomeColumn(purchaseBarcodePoolRecordList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodePoolItemMapper.deleteByMainId(id);
        this.purchaseBarcodePoolRecordMapper.deleteByMainId(id);
        this.purchaseBarcodePoolHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodePoolItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodePoolRecordMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodePoolHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional
    public void addByBarcodeInfo(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList) {
        if (sysBarcodeList != null && sysBarcodeList.size() > 0) {
            for (PurchaseBarcodeInfoDetail detail : sysBarcodeList) {
                PurchaseBarcodePoolHead poolHead = new PurchaseBarcodePoolHead();
                poolHead.setOriginalBarcode(detail.getOriginalBarcode());
                poolHead.setBarcode(detail.getBarcode());
                poolHead.setInfoNumber(purchaseBarcodeInfoHead.getInfoNumber());
                poolHead.setRuleCode(purchaseBarcodeInfoHead.getRuleCode());
                poolHead.setRuleId(purchaseBarcodeInfoHead.getRuleId());
                poolHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
                poolHead.setPrintNumber(detail.getPrintNumber());
                poolHead.setPrintedNumber(0);
                poolHead.setUsed("1");
                this.save((Object)poolHead);
                ArrayList<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList = new ArrayList<PurchaseBarcodePoolItem>();
                for (PurchaseBarcodeInfoItem entity : purchaseBarcodeInfoItemList) {
                    PurchaseBarcodePoolItem purchaseBarcodePoolItem = new PurchaseBarcodePoolItem();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)purchaseBarcodePoolItem));
                    purchaseBarcodePoolItem.setHeadId(poolHead.getId());
                    purchaseBarcodePoolItem.setId(null);
                    for (String attr : entity.getAttribute().split(",")) {
                        if (!poolHead.getOriginalBarcode().contains(attr)) continue;
                        purchaseBarcodePoolItem.setAttribute(attr);
                    }
                    purchaseBarcodePoolItemList.add(purchaseBarcodePoolItem);
                }
                this.purchaseBarcodePoolItemMapper.insertBatchSomeColumn(purchaseBarcodePoolItemList);
            }
        }
    }
}

