/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.excel;

import com.els.common.excel.Excel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public final class ExcelUtil {
    public static String outputFile = "/zlxx/excel_demo.xls";
    private static String[] HEAD_LIST = new String[]{"\u5e8f\u53f7", "\u540d\u5b57", "\u5e74\u9f84", "\u5907\u6ce8"};
    private static String[] VALUE_LIST = new String[]{"01", "sfli.sir", "20", "1983-01-01", "........."};
    private static String[] FIELD_LIST = new String[]{"index", "name", "age", "content"};

    private ExcelUtil() {
    }

    public static void main(String[] args) throws Exception {
        new ExcelUtil().testReadExcel();
    }

    public void testCreateExcel() {
        List<Map<String, Object>> dataList = this.getDataList();
        List<String> headList = this.getHeadList();
        List<String> fieldList = this.getFieldList();
        try {
            ExcelUtil.createExcel("TEST01.xls", headList, fieldList, dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testReadExcel() throws Exception {
        String excelUrl = "C:/javadeveloper/workspace/Mybatis_one/src/\u6d4b\u8bd5\u53f0\u8d262003.xls";
        List<String[]> list = ExcelUtil.readExcel(excelUrl);
        for (String[] str : list) {
            for (String string : str) {
            }
        }
    }

    private List<Map<String, Object>> getDataList() {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("index", "001");
        map.put("name", "\u5f20\u4e09");
        map.put("age", "22");
        map.put("content", "\u5927\u5bb6\u597d");
        map.put("date", new Date());
        dataList.add(map);
        dataList.add(map);
        dataList.add(map);
        return dataList;
    }

    private List<String> getHeadList() {
        ArrayList<String> headList = new ArrayList<String>();
        headList.add("\u5e8f\u53f7");
        headList.add("\u540d\u5b57");
        headList.add("\u5e74\u9f84");
        headList.add("\u51fa\u751f");
        headList.add("\u5907\u6ce8");
        return headList;
    }

    private List<String> getFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("index");
        fieldList.add("name");
        fieldList.add("age");
        fieldList.add("date");
        fieldList.add("content");
        return fieldList;
    }

    public static void createExcel(String excelName, String[] headList, String[] fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(CellType.STRING);
            cell.setCellValue(headList[i]);
        }
        for (int n = 0; n < dataList.size(); ++n) {
            HSSFRow rowValue = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            for (int i = 0; i < fieldList.length; ++i) {
                HSSFCell cell = rowValue.createCell(i);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList[i])));
            }
        }
        FileOutputStream fOut = new FileOutputStream(excelName);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static void createExcel(String excelName, List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(CellType.STRING);
            cell.setCellValue(headList.get(i));
        }
        for (int n = 0; n < dataList.size(); ++n) {
            HSSFRow rowValue = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            for (int i = 0; i < fieldList.size(); ++i) {
                HSSFCell cell = rowValue.createCell(i);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i))));
            }
        }
        FileOutputStream fOut = new FileOutputStream(excelName);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static HSSFWorkbook createExcel(List<String> headList, List<String> fieldList, List<Map<String, Object>> dataList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.size(); ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(CellType.STRING);
            cell.setCellValue(headList.get(i));
        }
        for (int n = 0; n < dataList.size(); ++n) {
            HSSFRow rowValue = sheet.createRow(n + 1);
            Map<String, Object> dataMap = dataList.get(n);
            for (int i = 0; i < fieldList.size(); ++i) {
                HSSFCell cell = rowValue.createCell(i);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(ExcelUtil.objToString(dataMap.get(fieldList.get(i))));
            }
        }
        return workbook;
    }

    private static String objToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            return null;
        }
        return obj.toString();
    }

    public static void bulidExcel(String excelName, String[] headList, List<String[]> valueList) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headList.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellType(CellType.STRING);
            cell.setCellValue(headList[i]);
        }
        for (int n = 0; n < valueList.size(); ++n) {
            HSSFRow rowValue = sheet.createRow(n + 1);
            String[] valueArray = valueList.get(n);
            for (int i = 0; i < valueArray.length; ++i) {
                HSSFCell cell = rowValue.createCell(i);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(valueArray[i]);
            }
        }
        FileOutputStream fOut = new FileOutputStream(excelName);
        workbook.write((OutputStream)fOut);
        fOut.flush();
        fOut.close();
    }

    public static List<String[]> readExcel(String excelName) throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excelName));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null) continue;
            int col = hssfrow.getPhysicalNumberOfCells();
            String[] arrayString = new String[col];
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i);
                if (cell == null) {
                    arrayString[i] = "";
                    continue;
                }
                if (cell.getCellType() == CellType.STRING) {
                    if (CellType.NUMERIC != cell.getCellType()) continue;
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date d = cell.getDateCellValue();
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        arrayString[i] = formater.format(d);
                        continue;
                    }
                    arrayString[i] = new BigDecimal(cell.getNumericCellValue()).longValue() + "";
                    continue;
                }
                arrayString[i] = cell.getStringCellValue().trim();
            }
            list.add(arrayString);
        }
        return list;
    }

    public static List<List<Object>> readExcelByList(String excelName) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook((InputStream)new FileInputStream(excelName));
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null) continue;
            int col = hssfrow.getPhysicalNumberOfCells();
            ArrayList<String> arrayString = new ArrayList<String>();
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i);
                if (cell == null) {
                    arrayString.add("");
                    continue;
                }
                if (cell.getCellType() == CellType.STRING) {
                    arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    continue;
                }
                arrayString.add(cell.getStringCellValue().trim());
            }
            list.add(arrayString);
        }
        return list;
    }

    public static List<List<Object>> readExcelByInputStream(InputStream inputstream) throws Exception {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        HSSFWorkbook hssfworkbook = new HSSFWorkbook(inputstream);
        HSSFSheet hssfsheet = hssfworkbook.getSheetAt(0);
        for (int j = 0; j < hssfsheet.getPhysicalNumberOfRows(); ++j) {
            HSSFRow hssfrow = hssfsheet.getRow(j);
            if (hssfrow == null) continue;
            int col = hssfrow.getPhysicalNumberOfCells();
            ArrayList<String> arrayString = new ArrayList<String>();
            for (int i = 0; i < col; ++i) {
                HSSFCell cell = hssfrow.getCell(i);
                if (cell == null) {
                    arrayString.add("");
                    continue;
                }
                if (cell.getCellType() == CellType.STRING) {
                    arrayString.add(new Double(cell.getNumericCellValue()).toString());
                    continue;
                }
                arrayString.add(cell.getStringCellValue().trim());
            }
            list.add(arrayString);
        }
        return list;
    }

    @Deprecated
    public static Collection importExcel(File file, Class pojoClass) {
        try {
            FileInputStream in = new FileInputStream(file);
            return ExcelUtil.importExcelByIs(in, pojoClass);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Collection importExcelByIs(InputStream inputstream, Class pojoClass) {
        ArrayList dist = new ArrayList();
        try {
            Field[] filed = pojoClass.getDeclaredFields();
            HashMap<String, Method> fieldSetMap = new HashMap<String, Method>();
            HashMap<String, Method> fieldSetConvertMap = new HashMap<String, Method>();
            for (int i = 0; i < filed.length; ++i) {
                Field f = filed[i];
                Excel excel = f.getAnnotation(Excel.class);
                if (excel == null) continue;
                String fieldname = f.getName();
                String setMethodName = "set" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
                Method setMethod = pojoClass.getMethod(setMethodName, f.getType());
                fieldSetMap.put(excel.exportName(), setMethod);
                if (excel.importConvertSign() != 1) continue;
                StringBuffer setConvertMethodName = new StringBuffer("convertSet");
                setConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
                setConvertMethodName.append(fieldname.substring(1));
                Method getConvertMethod = pojoClass.getMethod(setConvertMethodName.toString(), String.class);
                fieldSetConvertMap.put(excel.exportName(), getConvertMethod);
            }
            HSSFWorkbook book = new HSSFWorkbook(inputstream);
            HSSFSheet sheet = book.getSheetAt(0);
            Iterator row = sheet.rowIterator();
            Row title = (Row)row.next();
            Iterator cellTitle = title.cellIterator();
            HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
            int i = 0;
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                titlemap.put(i, value);
                ++i;
            }
            while (row.hasNext()) {
                Row rown = (Row)row.next();
                Iterator cellbody = rown.cellIterator();
                Object tObject = pojoClass.newInstance();
                int k = 0;
                while (cellbody.hasNext()) {
                    Cell cell = (Cell)cellbody.next();
                    String titleString = (String)titlemap.get(k);
                    if (fieldSetMap.containsKey(titleString)) {
                        Method setMethod = (Method)fieldSetMap.get(titleString);
                        Type[] ts = setMethod.getGenericParameterTypes();
                        String xclass = ts[0].toString();
                        if (CellType.STRING == cell.getCellType() && fieldSetConvertMap.containsKey(titleString)) {
                            ((Method)fieldSetConvertMap.get(titleString)).invoke(tObject, cell.getStringCellValue());
                        } else if ("class java.lang.String".equals(xclass)) {
                            cell.setCellType(CellType.STRING);
                            setMethod.invoke(tObject, cell.getStringCellValue());
                        } else if ("class java.util.Date".equals(xclass)) {
                            Date cellDate = null;
                            cellDate = CellType.NUMERIC == cell.getCellType() ? cell.getDateCellValue() : ExcelUtil.stringToDate(cell.getStringCellValue());
                            setMethod.invoke(tObject, cellDate);
                        } else if ("class java.lang.Boolean".equals(xclass)) {
                            boolean valBool = CellType.BOOLEAN == cell.getCellType() ? cell.getBooleanCellValue() : cell.getStringCellValue().equalsIgnoreCase("true") || !cell.getStringCellValue().equals("0");
                            setMethod.invoke(tObject, valBool);
                        } else if ("class java.lang.Integer".equals(xclass)) {
                            Integer valInt = CellType.NUMERIC == cell.getCellType() ? Integer.valueOf(new Double(cell.getNumericCellValue()).intValue()) : new Integer(cell.getStringCellValue());
                            setMethod.invoke(tObject, valInt);
                        } else if ("class java.lang.Long".equals(xclass)) {
                            Long valLong = CellType.NUMERIC == cell.getCellType() ? Long.valueOf(new Double(cell.getNumericCellValue()).longValue()) : new Long(cell.getStringCellValue());
                            setMethod.invoke(tObject, valLong);
                        } else if ("class java.math.BigDecimal".equals(xclass)) {
                            BigDecimal valDecimal = CellType.NUMERIC == cell.getCellType() ? new BigDecimal(cell.getNumericCellValue()) : new BigDecimal(cell.getStringCellValue());
                            setMethod.invoke(tObject, valDecimal);
                        }
                    }
                    ++k;
                }
                dist.add(tObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dist;
    }

    private static Date stringToDate(String cellValue) {
        if (cellValue.length() > 19) {
            cellValue = cellValue.substring(0, 19);
        }
        Calendar calendar = Calendar.getInstance();
        String[] dateStr = cellValue.split(" ");
        String[] dateInfo = dateStr[0].split("-");
        if (dateInfo.length != 3) {
            dateInfo = dateStr[0].split("/");
        }
        if (dateInfo.length != 3) {
            return null;
        }
        int year = Integer.parseInt(dateInfo[0]);
        int month = Integer.parseInt(dateInfo[1]) - 1;
        int day = Integer.parseInt(dateInfo[2]);
        calendar.set(year, month, day);
        if (dateStr.length > 1) {
            String[] timeStr = dateStr[1].split(":");
            if (timeStr.length == 3) {
                int hour = Integer.parseInt(timeStr[0]);
                int minute = Integer.parseInt(timeStr[1]);
                int second = Integer.parseInt(timeStr[2]);
                calendar.set(11, hour);
                calendar.set(12, minute);
                calendar.set(13, second);
            } else {
                return null;
            }
        }
        return calendar.getTime();
    }
}

